/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.http;

import android.os.Looper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import org.prebid.mobile.http.HTTPResponse;
import org.prebid.mobile.http.HttpErrorCode;
import org.prebid.mobile.tasksmanager.TasksManager;

public abstract class HTTPGet {
    protected abstract void onPostExecute(HTTPResponse var1);

    public void execute() {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            TasksManager.getInstance().executeOnBackgroundThread(new Runnable(){

                @Override
                public void run() {
                    HTTPResponse response = HTTPGet.this.makeHttpRequest();
                    HTTPGet.this.onPostExecute(response);
                }
            });
        } else {
            HTTPResponse response = this.makeHttpRequest();
            this.onPostExecute(response);
        }
    }

    protected abstract String getUrl();

    private HttpURLConnection createConnection(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(false);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setRequestMethod("GET");
        return connection;
    }

    private void setConnectionParams(HttpURLConnection connection) throws ProtocolException {
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(20000);
    }

    protected HTTPResponse makeHttpRequest() {
        HTTPResponse out = new HTTPResponse();
        HttpURLConnection connection = null;
        try {
            String line;
            URL reqUrl = new URL(this.getUrl());
            if (reqUrl.getHost() == null) {
                out.setSucceeded(false);
                return out;
            }
            connection = this.createConnection(reqUrl);
            this.setConnectionParams(connection);
            connection.connect();
            StringBuilder builder = new StringBuilder();
            InputStream is = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            reader.close();
            is.close();
            String responseString = builder.toString();
            out.setHeaders(connection.getHeaderFields());
            out.setResponseBody(responseString);
            boolean isStatusOK = connection.getResponseCode() == 200;
            out.setSucceeded(isStatusOK);
        }
        catch (MalformedURLException e) {
            out.setSucceeded(false);
            out.setErrorCode(HttpErrorCode.URI_SYNTAX_ERROR);
        }
        catch (IOException e) {
            out.setSucceeded(false);
            out.setErrorCode(HttpErrorCode.TRANSPORT_ERROR);
        }
        catch (Exception e) {
            out.setSucceeded(false);
            out.setErrorCode(HttpErrorCode.UNKNOWN_ERROR);
            e.printStackTrace();
        }
        return out;
    }
}

