/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.tasksmanager;

import java.util.concurrent.Executor;
import org.prebid.mobile.tasksmanager.BackgroundThreadExecutor;
import org.prebid.mobile.tasksmanager.CancellableExecutor;
import org.prebid.mobile.tasksmanager.MainThreadExecutor;

public class TasksManager {
    private static TasksManager instance = null;
    public Executor mainThreadExecutor = new MainThreadExecutor();
    public Executor backgroundThreadExecutor = new BackgroundThreadExecutor();

    private TasksManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized TasksManager getInstance() {
        if (instance != null) return instance;
        Class<TasksManager> clazz = TasksManager.class;
        synchronized (TasksManager.class) {
            instance = new TasksManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void executeOnMainThread(Runnable task) {
        this.mainThreadExecutor.execute(task);
    }

    public void cancelTaskOnMainThread(Runnable task) {
        ((CancellableExecutor)this.mainThreadExecutor).cancel(task);
    }

    public void executeOnBackgroundThread(Runnable task) {
        this.backgroundThreadExecutor.execute(task);
    }

    public void cancelTaksOnBackgroundThread(Runnable task) {
        ((CancellableExecutor)this.backgroundThreadExecutor).cancel(task);
    }
}

