/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile;

import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class NativeEventTracker {
    EVENT_TYPE event;
    ArrayList<EVENT_TRACKING_METHOD> methods;
    Object extObject;

    public NativeEventTracker(EVENT_TYPE event, ArrayList<EVENT_TRACKING_METHOD> methods) throws Exception {
        this.event = event;
        if (methods == null || methods.isEmpty()) {
            throw new Exception("Methods are required");
        }
        this.methods = methods;
    }

    public void setExt(Object extObject) {
        if (extObject instanceof JSONObject || extObject instanceof JSONArray) {
            this.extObject = extObject;
        }
    }

    public EVENT_TYPE getEvent() {
        return this.event;
    }

    public ArrayList<EVENT_TRACKING_METHOD> getMethods() {
        return this.methods;
    }

    public Object getExtObject() {
        return this.extObject;
    }

    public static enum EVENT_TRACKING_METHOD {
        IMAGE(1),
        JS(2),
        CUSTOM(500);

        private int id;

        private EVENT_TRACKING_METHOD(int id) {
            this.id = id;
        }

        public int getID() {
            return this.id;
        }

        public void setID(int id) {
            if (this.equals((Object)CUSTOM) && !this.inExistingValue(id)) {
                this.id = id;
            }
        }

        private boolean inExistingValue(int id) {
            EVENT_TRACKING_METHOD[] possibleValues;
            for (EVENT_TRACKING_METHOD value : possibleValues = (EVENT_TRACKING_METHOD[])this.getDeclaringClass().getEnumConstants()) {
                if (value.equals((Object)CUSTOM) || value.getID() != id) continue;
                return true;
            }
            return false;
        }
    }

    public static enum EVENT_TYPE {
        IMPRESSION(1),
        VIEWABLE_MRC50(2),
        VIEWABLE_MRC100(3),
        VIEWABLE_VIDEO50(4),
        CUSTOM(500);

        private int id;

        private EVENT_TYPE(int id) {
            this.id = id;
        }

        public int getID() {
            return this.id;
        }

        public void setID(int id) {
            if (this.equals((Object)CUSTOM) && !this.inExistingValue(id)) {
                this.id = id;
            }
        }

        private boolean inExistingValue(int id) {
            EVENT_TYPE[] possibleValues;
            for (EVENT_TYPE value : possibleValues = (EVENT_TYPE[])this.getDeclaringClass().getEnumConstants()) {
                if (value.equals((Object)CUSTOM) || value.getID() != id) continue;
                return true;
            }
            return false;
        }
    }
}

