/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.prebid.mobile.ImpressionTrackerListener;
import org.prebid.mobile.LogUtil;
import org.prebid.mobile.http.HTTPGet;
import org.prebid.mobile.http.HTTPResponse;
import org.prebid.mobile.http.HttpErrorCode;

public class SharedNetworkManager {
    private static SharedNetworkManager manager;
    private ArrayList<UrlObject> urls = new ArrayList();
    private Timer retryTimer;
    private static final int TOTAL_RETRY_TIMES = 3;
    private static final int TOTAL_RETRY_WAIT_INTERVAL_MILLISECONDS = 10000;
    private static final String permission = "android.permission.ACCESS_NETWORK_STATE";
    private boolean permitted;
    private ImpressionTrackerListener impressionTrackerListener;

    public static SharedNetworkManager getInstance(Context context) {
        if (manager == null) {
            manager = new SharedNetworkManager(context);
        }
        return manager;
    }

    private SharedNetworkManager(Context context) {
        int permissionStatus = context.getPackageManager().checkPermission(permission, context.getPackageName());
        this.permitted = permissionStatus == 0;
    }

    public boolean isConnected(Context context) {
        if (this.permitted) {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            return activeNetwork != null && activeNetwork.isConnected();
        }
        return true;
    }

    synchronized void addURL(String url, Context context) {
        this.addURL(url, context, null);
    }

    synchronized void addURL(String url, Context context, ImpressionTrackerListener impressionTrackerListener) {
        LogUtil.d("SharedNetworkManager adding URL for Network Retry");
        this.impressionTrackerListener = impressionTrackerListener;
        this.urls.add(new UrlObject(url));
        this.startTimer(context);
    }

    private void startTimer(Context context) {
        if (this.retryTimer == null) {
            final WeakReference<Context> weakContext = new WeakReference<Context>(context);
            this.retryTimer = new Timer();
            this.retryTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    Context context = (Context)weakContext.get();
                    if (context != null) {
                        while (!SharedNetworkManager.this.urls.isEmpty() && SharedNetworkManager.this.isConnected(context)) {
                            final UrlObject urlObject = (UrlObject)SharedNetworkManager.this.urls.remove(0);
                            if (urlObject.retryTimes >= 3) continue;
                            HTTPGet fire = new HTTPGet(){

                                @Override
                                protected void onPostExecute(HTTPResponse response) {
                                    if (response == null || !response.getSucceeded() && response.getErrorCode() == HttpErrorCode.CONNECTION_FAILURE) {
                                        ++urlObject.retryTimes;
                                        SharedNetworkManager.this.urls.add(urlObject);
                                    } else if (SharedNetworkManager.this.impressionTrackerListener != null) {
                                        SharedNetworkManager.this.impressionTrackerListener.onImpressionTrackerFired();
                                    }
                                }

                                @Override
                                protected String getUrl() {
                                    return urlObject.url;
                                }
                            };
                            fire.execute();
                        }
                        if (SharedNetworkManager.this.urls.isEmpty()) {
                            SharedNetworkManager.this.stopTimer();
                        }
                    } else {
                        SharedNetworkManager.this.stopTimer();
                    }
                }
            }, 10000L, 10000L);
        }
    }

    private void stopTimer() {
        if (this.retryTimer != null) {
            this.retryTimer.cancel();
            this.retryTimer = null;
        }
    }

    class UrlObject {
        String url;
        int retryTimes;

        UrlObject(String url) {
            this.url = url;
            this.retryTimes = 0;
        }
    }
}

