/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.addendum;

import android.webkit.WebView;
import java.util.Set;
import org.prebid.mobile.addendum.Pair;
import org.prebid.mobile.addendum.PbFindSizeError;

final class PbFindSizeErrorFactory {
    static final int UNSPECIFIED_CODE = 201;
    static final int UNSUPPORTED_ANDROID_IPI_CODE = 202;
    static final int COMPOSITE_FAILURE_CODE = 203;
    static final int NO_WEBVIEW_CODE = 210;
    static final int WEBVIEW_FAILED_CODE = 220;
    static final int NO_HTML_CODE = 230;
    static final int NO_SIZE_OBJECT_CODE = 240;
    static final int NO_SIZE_VALUE_CODE = 250;
    static final int SIZE_UNPARSED_CODE = 260;
    static final PbFindSizeError UNSPECIFIED = PbFindSizeErrorFactory.getUnspecifiedError();
    static final PbFindSizeError NO_WEB_VIEW = PbFindSizeErrorFactory.getNoWebViewError();
    static final PbFindSizeError NO_HTML = PbFindSizeErrorFactory.getNoHtmlError();
    static final PbFindSizeError NO_SIZE_OBJECT = PbFindSizeErrorFactory.getNoSizeObjectError();
    static final PbFindSizeError NO_SIZE_VALUE = PbFindSizeErrorFactory.getNoSizeValueError();
    static final PbFindSizeError SIZE_UNPARSED = PbFindSizeErrorFactory.getSizeUnparsedError();

    private PbFindSizeErrorFactory() {
    }

    private static PbFindSizeError getUnspecifiedError() {
        return PbFindSizeErrorFactory.getError(201, "Unspecified error");
    }

    static PbFindSizeError getUnsupportedAndroidIpiError(int currentAndroidApi, int necessaryAndroidApi) {
        return PbFindSizeErrorFactory.getError(202, "AndroidAPI:" + currentAndroidApi + " doesn't support the functionality. Minimum AndroidAPI is:" + necessaryAndroidApi);
    }

    static PbFindSizeError getCompositeFailureError(Set<Pair<WebView, PbFindSizeError>> errorSet) {
        StringBuilder result = new StringBuilder();
        result.append("There is a set of errors:\n");
        for (Pair<WebView, PbFindSizeError> webViewFindSizeError : errorSet) {
            result.append("    WebView:").append(webViewFindSizeError.first).append(" errorCode:").append(((PbFindSizeError)webViewFindSizeError.second).getCode()).append(" errorDescription:").append(((PbFindSizeError)webViewFindSizeError.second).getDescription()).append("\n");
        }
        return PbFindSizeErrorFactory.getError(203, result.toString());
    }

    private static PbFindSizeError getNoWebViewError() {
        return PbFindSizeErrorFactory.getError(210, "The view doesn't include WebView");
    }

    private static PbFindSizeError getWebViewFailedError() {
        return PbFindSizeErrorFactory.getError(220, "The view doesn't include WebView");
    }

    private static PbFindSizeError getNoHtmlError() {
        return PbFindSizeErrorFactory.getError(230, "The WebView doesn't have HTML");
    }

    private static PbFindSizeError getNoSizeObjectError() {
        return PbFindSizeErrorFactory.getError(240, "The HTML doesn't contain a size object");
    }

    private static PbFindSizeError getNoSizeValueError() {
        return PbFindSizeErrorFactory.getError(250, "The size object doesn't contain a value");
    }

    private static PbFindSizeError getSizeUnparsedError() {
        return PbFindSizeErrorFactory.getError(260, "The size value has a wrong format");
    }

    private static PbFindSizeError getError(int code, String description) {
        return new PbFindSizeError(code, description);
    }
}

