/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.httpclient;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.cookie.CookieSpecFactory;
import org.apache.http.cookie.CookieSpecRegistry;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.engine.Engine;
import org.restlet.engine.adapter.ClientCall;
import org.restlet.engine.util.ReferenceUtils;
import org.restlet.ext.httpclient.internal.HttpIdleConnectionReaper;
import org.restlet.ext.httpclient.internal.HttpMethodCall;
import org.restlet.ext.httpclient.internal.IgnoreCookieSpecFactory;

public class HttpClientHelper
extends org.restlet.engine.adapter.HttpClientHelper {
    private volatile DefaultHttpClient httpClient = null;
    private volatile HttpIdleConnectionReaper idleConnectionReaper;

    public HttpClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.HTTP);
        this.getProtocols().add(Protocol.HTTPS);
    }

    protected void configure(DefaultHttpClient httpClient) {
        if (this.getRetryHandler() != null) {
            try {
                HttpRequestRetryHandler retryHandler = (HttpRequestRetryHandler)Engine.loadClass((String)this.getRetryHandler()).newInstance();
                this.httpClient.setHttpRequestRetryHandler(retryHandler);
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "An error occurred during the instantiation of the retry handler.", e);
            }
        }
        CookieSpecRegistry csr = new CookieSpecRegistry();
        csr.register("ignore", (CookieSpecFactory)new IgnoreCookieSpecFactory());
        this.httpClient.setCookieSpecs(csr);
    }

    protected void configure(HttpParams params) {
        ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)this.getMaxTotalConnections());
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)new ConnPerRouteBean(this.getMaxConnectionsPerHost()));
        HttpClientParams.setAuthenticating((HttpParams)params, (boolean)false);
        HttpClientParams.setRedirecting((HttpParams)params, (boolean)this.isFollowRedirects());
        HttpClientParams.setCookiePolicy((HttpParams)params, (String)"ignore");
        HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)this.getTcpNoDelay());
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)this.getSocketConnectTimeoutMs());
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)this.getSocketTimeout());
        String httpProxyHost = this.getProxyHost();
        if (httpProxyHost != null) {
            HttpHost proxy = new HttpHost(httpProxyHost, this.getProxyPort());
            params.setParameter("http.route.default-proxy", (Object)proxy);
        }
    }

    protected void configure(SchemeRegistry schemeRegistry) {
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
    }

    public ClientCall create(Request request) {
        HttpMethodCall result = null;
        try {
            result = new HttpMethodCall(this, request.getMethod().toString(), ReferenceUtils.update((Reference)request.getResourceRef(), (Request)request).toString(), request.isEntityAvailable());
        }
        catch (IOException ioe) {
            this.getLogger().log(Level.WARNING, "Unable to create the HTTP client call", ioe);
        }
        return result;
    }

    protected ClientConnectionManager createClientConnectionManager(HttpParams params, SchemeRegistry schemeRegistry) {
        return new ThreadSafeClientConnManager(params, schemeRegistry);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public long getIdleCheckInterval() {
        return Long.parseLong(this.getHelpedParameters().getFirstValue("idleCheckInterval", "0"));
    }

    public long getIdleTimeout() {
        return Long.parseLong(this.getHelpedParameters().getFirstValue("idleTimeout", "10000"));
    }

    public int getMaxConnectionsPerHost() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxConnectionsPerHost", "10"));
    }

    public int getMaxTotalConnections() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxTotalConnections", "20"));
    }

    public String getProxyHost() {
        return this.getHelpedParameters().getFirstValue("proxyHost", System.getProperty("http.proxyHost"));
    }

    public int getProxyPort() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("proxyPort", System.getProperty("http.proxyPort", "3128")));
    }

    public String getRetryHandler() {
        return this.getHelpedParameters().getFirstValue("retryHandler", null);
    }

    public int getSocketTimeout() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("socketTimeout", "0"));
    }

    public int getStopIdleTimeout() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("stopIdleTimeout", "1000"));
    }

    public boolean getTcpNoDelay() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("tcpNoDelay", "false"));
    }

    public boolean isFollowRedirects() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("followRedirects", "false"));
    }

    public void setIdleConnectionReaper(HttpIdleConnectionReaper connectionReaper) {
        this.idleConnectionReaper = connectionReaper;
    }

    public void start() throws Exception {
        super.start();
        BasicHttpParams params = new BasicHttpParams();
        this.configure((HttpParams)params);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        this.configure(schemeRegistry);
        ClientConnectionManager connectionManager = this.createClientConnectionManager((HttpParams)params, schemeRegistry);
        this.httpClient = new DefaultHttpClient(connectionManager, (HttpParams)params);
        this.configure(this.httpClient);
        if (this.idleConnectionReaper != null) {
            this.idleConnectionReaper.stop();
        }
        this.idleConnectionReaper = new HttpIdleConnectionReaper((HttpClient)this.httpClient, this.getIdleCheckInterval(), this.getIdleTimeout());
        this.getLogger().info("Starting the Apache HTTP client");
    }

    public void stop() throws Exception {
        if (this.idleConnectionReaper != null) {
            this.idleConnectionReaper.stop();
        }
        if (this.getHttpClient() != null) {
            this.getHttpClient().getConnectionManager().closeExpiredConnections();
            this.getHttpClient().getConnectionManager().closeIdleConnections((long)this.getStopIdleTimeout(), TimeUnit.MILLISECONDS);
            this.getHttpClient().getConnectionManager().shutdown();
            this.getLogger().info("Stopping the HTTP client");
        }
    }
}

