/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jackson;

import java.io.IOException;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.ext.jackson.JacksonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Resource;

public class JacksonConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_APPLICATION_XML = new VariantInfo(MediaType.APPLICATION_XML);
    private static final VariantInfo VARIANT_APPLICATION_YAML = new VariantInfo(MediaType.APPLICATION_YAML);
    private static final VariantInfo VARIANT_JSON = new VariantInfo(MediaType.APPLICATION_JSON);
    private static final VariantInfo VARIANT_JSON_SMILE = new VariantInfo(MediaType.APPLICATION_JSON_SMILE);
    private static final VariantInfo VARIANT_TEXT_CSV = new VariantInfo(MediaType.TEXT_CSV);
    private static final VariantInfo VARIANT_TEXT_XML = new VariantInfo(MediaType.TEXT_XML);
    private static final VariantInfo VARIANT_TEXT_YAML = new VariantInfo(MediaType.TEXT_YAML);

    protected <T> JacksonRepresentation<T> create(MediaType mediaType, T source) {
        return new JacksonRepresentation<T>(mediaType, source);
    }

    protected <T> JacksonRepresentation<T> create(Representation source, Class<T> objectClass) {
        return new JacksonRepresentation<T>(source, objectClass);
    }

    public List<Class<?>> getObjectClasses(Variant source) {
        List result = null;
        if (VARIANT_JSON.isCompatible(source) || VARIANT_JSON_SMILE.isCompatible(source) || VARIANT_APPLICATION_XML.isCompatible(source) || VARIANT_TEXT_XML.isCompatible(source) || VARIANT_APPLICATION_YAML.isCompatible(source) || VARIANT_TEXT_YAML.isCompatible(source) || VARIANT_TEXT_CSV.isCompatible(source)) {
            result = this.addObjectClass(result, Object.class);
            result = this.addObjectClass(result, JacksonRepresentation.class);
        }
        return result;
    }

    public List<VariantInfo> getVariants(Class<?> source) {
        List result = null;
        if (source != null) {
            result = this.addVariant(result, VARIANT_JSON);
            result = this.addVariant(result, VARIANT_JSON_SMILE);
            result = this.addVariant(result, VARIANT_APPLICATION_XML);
            result = this.addVariant(result, VARIANT_TEXT_XML);
            result = this.addVariant(result, VARIANT_APPLICATION_YAML);
            result = this.addVariant(result, VARIANT_TEXT_YAML);
            result = this.addVariant(result, VARIANT_TEXT_CSV);
        }
        return result;
    }

    public float score(Object source, Variant target, Resource resource) {
        float result = -1.0f;
        result = source instanceof JacksonRepresentation ? 1.0f : (target == null ? 0.5f : (VARIANT_JSON.isCompatible(target) ? 0.8f : (VARIANT_JSON_SMILE.isCompatible(target) ? 0.8f : (VARIANT_APPLICATION_XML.isCompatible(target) ? 0.8f : (VARIANT_TEXT_XML.isCompatible(target) ? 0.8f : (VARIANT_APPLICATION_YAML.isCompatible(target) ? 0.8f : (VARIANT_TEXT_YAML.isCompatible(target) ? 0.8f : (VARIANT_TEXT_CSV.isCompatible(target) ? 0.8f : 0.5f))))))));
        return result;
    }

    public <T> float score(Representation source, Class<T> target, Resource resource) {
        float result = -1.0f;
        if (source instanceof JacksonRepresentation) {
            result = 1.0f;
        } else if (target != null && JacksonRepresentation.class.isAssignableFrom(target)) {
            result = 1.0f;
        } else if (VARIANT_JSON.isCompatible((Variant)source)) {
            result = 0.8f;
        } else if (VARIANT_JSON_SMILE.isCompatible((Variant)source)) {
            result = 0.8f;
        } else if (VARIANT_APPLICATION_XML.isCompatible((Variant)source)) {
            result = 0.8f;
        } else if (VARIANT_TEXT_XML.isCompatible((Variant)source)) {
            result = 0.8f;
        } else if (VARIANT_APPLICATION_YAML.isCompatible((Variant)source)) {
            result = 0.8f;
        } else if (VARIANT_TEXT_YAML.isCompatible((Variant)source)) {
            result = 0.8f;
        } else if (VARIANT_TEXT_CSV.isCompatible((Variant)source)) {
            result = 0.8f;
        }
        return result;
    }

    public <T> T toObject(Representation source, Class<T> target, Resource resource) throws IOException {
        JacksonRepresentation<T> result = null;
        JacksonRepresentation<T> jacksonSource = null;
        if (source instanceof JacksonRepresentation) {
            jacksonSource = (JacksonRepresentation<T>)source;
        } else if (VARIANT_JSON.isCompatible((Variant)source) || VARIANT_JSON_SMILE.isCompatible((Variant)source) || VARIANT_APPLICATION_XML.isCompatible((Variant)source) || VARIANT_TEXT_XML.isCompatible((Variant)source) || VARIANT_APPLICATION_YAML.isCompatible((Variant)source) || VARIANT_TEXT_YAML.isCompatible((Variant)source) || VARIANT_TEXT_CSV.isCompatible((Variant)source)) {
            jacksonSource = this.create(source, target);
        }
        if (jacksonSource != null) {
            result = target != null && JacksonRepresentation.class.isAssignableFrom(target) ? jacksonSource : (JacksonRepresentation<T>)((Object)jacksonSource.getObject());
        }
        return (T)((Object)result);
    }

    public Representation toRepresentation(Object source, Variant target, Resource resource) {
        JacksonRepresentation<Object> result = null;
        if (source instanceof JacksonRepresentation) {
            result = (JacksonRepresentation<Object>)((Object)source);
        } else {
            if (target.getMediaType() == null) {
                target.setMediaType(MediaType.APPLICATION_JSON);
            }
            if (VARIANT_JSON_SMILE.isCompatible(target) || VARIANT_JSON.isCompatible(target) || VARIANT_APPLICATION_XML.isCompatible(target) || VARIANT_TEXT_XML.isCompatible(target) || VARIANT_APPLICATION_YAML.isCompatible(target) || VARIANT_TEXT_YAML.isCompatible(target) || VARIANT_TEXT_CSV.isCompatible(target)) {
                result = this.create(target.getMediaType(), source);
            }
        }
        return result;
    }

    public <T> void updatePreferences(List<Preference<MediaType>> preferences, Class<T> entity) {
        this.updatePreferences(preferences, MediaType.APPLICATION_JSON, 1.0f);
        this.updatePreferences(preferences, MediaType.APPLICATION_JSON_SMILE, 1.0f);
        this.updatePreferences(preferences, MediaType.APPLICATION_XML, 1.0f);
        this.updatePreferences(preferences, MediaType.TEXT_XML, 1.0f);
        this.updatePreferences(preferences, MediaType.APPLICATION_YAML, 1.0f);
        this.updatePreferences(preferences, MediaType.TEXT_YAML, 1.0f);
        this.updatePreferences(preferences, MediaType.TEXT_CSV, 1.0f);
    }
}

