/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio.internal.channel;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.io.IoUtils;
import org.restlet.engine.io.ReadableSelectionChannel;
import org.restlet.engine.io.SelectionChannel;
import org.restlet.engine.io.SelectorFactory;
import org.restlet.ext.nio.internal.buffer.Buffer;
import org.restlet.ext.nio.internal.buffer.BufferProcessor;
import org.restlet.util.SelectionListener;
import org.restlet.util.SelectionRegistration;

public class ChannelInputStream
extends InputStream
implements BufferProcessor {
    private final Buffer buffer;
    private final ReadableByteChannel channel;
    private volatile boolean endReached;
    private final SelectableChannel selectableChannel;
    private final SelectionChannel selectionChannel;
    private volatile SelectionRegistration selectionRegistration;

    public ChannelInputStream(ReadableByteChannel channel) {
        this.channel = channel;
        if (channel instanceof ReadableSelectionChannel) {
            this.selectionChannel = (ReadableSelectionChannel)channel;
            this.selectableChannel = null;
        } else if (channel instanceof SelectableChannel) {
            this.selectionChannel = null;
            this.selectableChannel = (SelectableChannel)((Object)channel);
        } else if (channel instanceof SelectionChannel) {
            this.selectionChannel = (SelectionChannel)channel;
            this.selectableChannel = null;
        } else {
            this.selectionChannel = null;
            this.selectableChannel = null;
        }
        this.buffer = new Buffer(IoUtils.BUFFER_SIZE);
        this.endReached = false;
        this.selectionRegistration = null;
    }

    @Override
    public boolean canLoop(Buffer buffer, Object ... args) {
        boolean result = true;
        if (args.length == 1) {
            result = args[0] == null;
        } else if (args.length == 2) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean couldFill(Buffer buffer, Object ... args) {
        return !this.endReached;
    }

    protected Buffer getBuffer() {
        return this.buffer;
    }

    @Override
    public int onDrain(Buffer buffer, int maxDrained, Object ... args) throws IOException {
        int result = 0;
        if (args.length == 1) {
            args[0] = this.getBuffer().drain();
            result = 1;
        } else if (args.length == 2) {
            byte[] targetArray = (byte[])args[0];
            int offset = (Integer)args[1];
            result = Math.min(maxDrained, this.getBuffer().remaining());
            this.getBuffer().drain(targetArray, offset, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int onFill(Buffer buffer, Object ... args) throws IOException {
        int result = buffer.fill(this.channel);
        if (result == 0) {
            if (Context.getCurrentLogger().isLoggable(Level.FINER)) {
                Context.getCurrentLogger().log(Level.FINER, "Couldn't fill the buffer immediately. Trying to register a select key to get more.");
            }
            if (this.selectionChannel != null) {
                if (this.selectionRegistration == null) {
                    this.selectionRegistration = this.selectionChannel.getRegistration();
                    this.selectionRegistration.setInterestOperations(1);
                    this.selectionRegistration.setSelectionListener(new SelectionListener(){

                        public void onSelected(SelectionRegistration selectionRegistration) throws IOException {
                            if (Context.getCurrentLogger().isLoggable(Level.FINER)) {
                                Context.getCurrentLogger().log(Level.FINER, "NbChannelInputStream selected");
                            }
                            selectionRegistration.suspend();
                            selectionRegistration.unblock();
                        }
                    });
                } else {
                    this.selectionRegistration.resume();
                }
                this.selectionRegistration.block();
                result = buffer.fill(this.channel);
            } else if (this.selectableChannel != null) {
                Selector selector = null;
                SelectionKey selectionKey = null;
                try {
                    selector = SelectorFactory.getSelector();
                    if (selector != null) {
                        selectionKey = this.selectableChannel.register(selector, 1);
                        selector.select(IoUtils.TIMEOUT_MS);
                    }
                }
                finally {
                    IoUtils.release((Selector)selector, selectionKey);
                }
                result = buffer.fill(this.channel);
            }
        }
        if (result == -1) {
            this.endReached = true;
            if (this.selectionRegistration != null) {
                this.selectionRegistration.setCanceling(true);
                this.selectionRegistration.setSelectionListener(null);
            }
        }
        return result;
    }

    @Override
    public void onFillEof() {
    }

    @Override
    public void postProcess(int drained) throws IOException {
    }

    @Override
    public int preProcess(int maxDrained, Object ... args) throws IOException {
        return 0;
    }

    @Override
    public int read() throws IOException {
        int result = 0;
        Object[] args = new Object[1];
        int bytesDrained = this.getBuffer().process(this, 1, args);
        if (bytesDrained == -1) {
            result = -1;
        } else if (bytesDrained == 1) {
            result = (Integer)args[0];
        } else {
            Context.getCurrentLogger().warning("Only one byte was needed but " + bytesDrained + " were drained.");
        }
        return result;
    }

    @Override
    public int read(byte[] targetArray, int offset, int length) throws IOException {
        return this.getBuffer().process(this, length, targetArray, offset);
    }
}

