/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio.internal.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngineResult;
import org.restlet.engine.io.WakeupListener;
import org.restlet.ext.nio.internal.buffer.Buffer;
import org.restlet.ext.nio.internal.channel.WritableBufferedChannel;
import org.restlet.ext.nio.internal.channel.WritableSelectionChannel;
import org.restlet.ext.nio.internal.connection.SslConnection;
import org.restlet.ext.nio.internal.state.IoState;
import org.restlet.ext.nio.internal.util.TasksListener;

public class WritableSslChannel
extends WritableBufferedChannel
implements TasksListener {
    private final SslConnection<?> connection;

    public WritableSslChannel(WritableSelectionChannel target, SslConnection<?> connection, WakeupListener wakeupListener) {
        super(new Buffer(connection.getPacketBufferSize(), connection.getHelper().isDirectBuffers()), target, wakeupListener);
        this.connection = connection;
    }

    @Override
    public boolean canLoop(Buffer buffer, Object ... args) {
        return this.getConnection().getOutboundWay().canLoop(buffer, args) || this.getConnection().isSslHandshaking();
    }

    @Override
    public boolean couldFill(Buffer buffer, Object ... args) {
        return super.couldFill(buffer, args) && this.getConnection().getSslEngineStatus() != SSLEngineResult.Status.CLOSED && (this.getConnection().getSslHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || this.getConnection().getSslHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP);
    }

    protected SslConnection<?> getConnection() {
        return this.connection;
    }

    @Override
    public void onCompleted() {
        if (this.getConnection().getOutboundWay().getIoState() == IoState.IDLE) {
            this.getConnection().getOutboundWay().setIoState(IoState.INTEREST);
        }
    }

    @Override
    public int onFill(Buffer buffer, Object ... args) throws IOException {
        int srcSize = buffer.remaining();
        ByteBuffer applicationBuffer = (ByteBuffer)args[0];
        SSLEngineResult.HandshakeStatus handshakeStatus = this.getConnection().getSslHandshakeStatus();
        SSLEngineResult sslResult = applicationBuffer.hasRemaining() || handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING ? this.getConnection().getSslEngine().wrap(applicationBuffer, buffer.getBytes()) : new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, handshakeStatus, 0, 0);
        this.getConnection().setSslResult(sslResult);
        return srcSize - buffer.remaining();
    }

    @Override
    public void postProcess(int drained) throws IOException {
        this.getConnection().handleSslResult();
    }

    @Override
    public int write(ByteBuffer sourceBuffer) throws IOException {
        return super.write(sourceBuffer);
    }
}

