/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio.internal.way;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Message;
import org.restlet.Response;
import org.restlet.data.Header;
import org.restlet.data.Status;
import org.restlet.ext.nio.ConnectionHelper;
import org.restlet.ext.nio.internal.buffer.Buffer;
import org.restlet.ext.nio.internal.buffer.BufferProcessor;
import org.restlet.ext.nio.internal.buffer.BufferState;
import org.restlet.ext.nio.internal.connection.Connection;
import org.restlet.ext.nio.internal.state.ConnectionState;
import org.restlet.ext.nio.internal.state.IoState;
import org.restlet.ext.nio.internal.state.MessageState;
import org.restlet.ext.nio.internal.util.CompletionListener;
import org.restlet.ext.nio.internal.way.InboundWay;
import org.restlet.ext.nio.internal.way.OutboundWay;
import org.restlet.routing.VirtualHost;
import org.restlet.util.SelectionListener;
import org.restlet.util.SelectionRegistration;
import org.restlet.util.Series;

public abstract class Way
implements SelectionListener,
CompletionListener,
BufferProcessor {
    private final Buffer buffer;
    private final Connection<?> connection;
    private volatile Series<Header> headers;
    private volatile IoState ioState;
    private final StringBuilder lineBuilder;
    private volatile BufferState lineBuilderState;
    private volatile Response message;
    private volatile MessageState messageState;
    private volatile SelectionRegistration registration;

    public Way(Connection<?> connection, int bufferSize) {
        this.connection = connection;
        this.buffer = new Buffer(bufferSize, this.getHelper().isDirectBuffers());
        this.headers = null;
        this.ioState = IoState.IDLE;
        this.lineBuilder = new StringBuilder();
        this.lineBuilderState = BufferState.IDLE;
        this.message = null;
        this.messageState = MessageState.IDLE;
        this.registration = new SelectionRegistration(0, (SelectionListener)this, null);
    }

    @Override
    public boolean canLoop(Buffer buffer, Object ... args) {
        return this.getConnection().getState() != ConnectionState.CLOSED && (this.getIoState() == IoState.PROCESSING || this.getIoState() == IoState.READY);
    }

    public void clear() {
        if (this.getLogger().isLoggable(Level.FINEST)) {
            if (this instanceof OutboundWay) {
                this.getLogger().log(Level.FINEST, "OutboundWay#clear: " + this);
            } else {
                this.getLogger().log(Level.FINEST, "InboundWay#clear: " + this);
            }
        }
        this.buffer.clear();
        this.headers = null;
        this.ioState = IoState.IDLE;
        this.clearLineBuilder();
        this.message = null;
        this.messageState = MessageState.IDLE;
        this.registration.clear();
    }

    protected void clearLineBuilder() {
        this.getLineBuilder().delete(0, this.getLineBuilder().length());
        this.setLineBuilderState(BufferState.IDLE);
    }

    public boolean couldDrain(Buffer buffer, Object ... args) {
        return false;
    }

    @Override
    public boolean couldFill(Buffer buffer, Object ... args) {
        return this.getConnection().getState() != ConnectionState.CLOSED;
    }

    public abstract Message getActualMessage();

    public Buffer getBuffer() {
        return this.buffer;
    }

    public Connection<?> getConnection() {
        return this.connection;
    }

    public Series<Header> getHeaders() {
        return this.headers;
    }

    public ConnectionHelper<?> getHelper() {
        return this.getConnection().getHelper();
    }

    public abstract int getInterestOperations();

    public IoState getIoState() {
        return this.ioState;
    }

    public StringBuilder getLineBuilder() {
        return this.lineBuilder;
    }

    public BufferState getLineBuilderState() {
        return this.lineBuilderState;
    }

    public int getLoadScore() {
        return this.getMessage() == null ? 0 : 1;
    }

    protected Logger getLogger() {
        return this.getConnection().getLogger();
    }

    public Response getMessage() {
        return this.message;
    }

    public MessageState getMessageState() {
        return this.messageState;
    }

    public SelectionRegistration getRegistration() {
        return this.registration;
    }

    protected boolean hasIoInterest() {
        return this.getIoState() != IoState.READY;
    }

    public boolean isAvailable() {
        return this.getMessageState().equals((Object)MessageState.IDLE) && this.getIoState().equals((Object)IoState.IDLE);
    }

    public boolean isEmpty() {
        return this.getBuffer().isEmpty();
    }

    public void onClosed() {
        this.setIoState(IoState.IDLE);
        this.setMessageState(MessageState.IDLE);
        this.setMessage(null);
        this.setHeaders(null);
        this.getBuffer().clear();
    }

    @Override
    public abstract int onDrain(Buffer var1, int var2, Object ... var3) throws IOException;

    public abstract void onError(Status var1);

    @Override
    public abstract int onFill(Buffer var1, Object ... var2) throws IOException;

    protected abstract void onHeadersCompleted() throws IOException;

    @Override
    public void onMessageCompleted(boolean endDetected) throws IOException {
        if (this.getLogger().isLoggable(Level.FINEST)) {
            if (this instanceof OutboundWay) {
                this.getLogger().log(Level.FINEST, "OutboundWay#onCompleted: " + endDetected);
            } else {
                this.getLogger().log(Level.FINEST, "InboundWay#onCompleted: " + endDetected);
            }
        }
        this.setIoState(IoState.IDLE);
        this.setMessageState(MessageState.IDLE);
        this.setMessage(null);
        this.setHeaders(null);
    }

    protected abstract void onPostProcessing();

    public void onSelected(SelectionRegistration selectionRegistration) {
        try {
            int drained;
            if (this.getMessage() != null) {
                Response.setCurrent((Response)this.getMessage());
                Application.setCurrent((Application)((Application)this.getMessage().getAttributes().get("org.restlet.application")));
                Context.setCurrent((Context)((Context)this.getMessage().getAttributes().get("org.restlet.context")));
                VirtualHost.setCurrent((Integer)((Integer)this.getMessage().getAttributes().get("org.restlet.virtualHost")));
            }
            if (this.getIoState() != IoState.READY) {
                this.setIoState(IoState.PROCESSING);
            }
            if (this.getLogger().isLoggable(Level.FINER)) {
                if (this instanceof InboundWay) {
                    this.getLogger().log(Level.FINER, "Processing IO for inbound way: " + this);
                } else {
                    this.getLogger().log(Level.FINER, "Processing IO for outbound way: " + this);
                }
            }
            if ((drained = this.processIoBuffer()) == -1 && this.getConnection().getState() == ConnectionState.CLOSING) {
                this.getBuffer().clear();
            } else if (this.getIoState() == IoState.PROCESSING) {
                this.onPostProcessing();
            }
        }
        catch (Exception e) {
            this.getConnection().onError("Error while processing a connection", e, Status.CONNECTOR_ERROR_COMMUNICATION);
        }
        if (this instanceof InboundWay) {
            this.getLogger().log(Level.FINER, "Inbound way selected. Done for : " + this);
        } else {
            this.getLogger().log(Level.FINER, "Outbound way selected. Done for : " + this);
        }
    }

    public abstract void onTimeOut();

    @Override
    public void postProcess(int drained) throws IOException {
    }

    @Override
    public int preProcess(int maxDrained, Object ... args) throws IOException {
        return 0;
    }

    protected int processIoBuffer() throws IOException {
        return this.getBuffer().process(this, 0, new Object[0]);
    }

    protected void setHeaders(Series<Header> headers) {
        this.headers = headers;
    }

    public void setIoState(IoState ioState) {
        if (ioState != this.ioState) {
            if (Context.getCurrentLogger().isLoggable(Level.FINER)) {
                if (this instanceof OutboundWay) {
                    Context.getCurrentLogger().log(Level.FINER, "OutboundWay#setIoState: " + (Object)((Object)ioState));
                } else {
                    Context.getCurrentLogger().log(Level.FINER, "InboundWay#setIoState: " + (Object)((Object)ioState));
                }
            }
            this.ioState = ioState;
        }
    }

    protected void setLineBuilderState(BufferState lineBuilderState) {
        this.lineBuilderState = lineBuilderState;
    }

    protected void setMessage(Response message) {
        this.message = message;
    }

    protected void setMessageState(MessageState messageState) {
        if (this.messageState != messageState) {
            this.messageState = messageState;
            if (this.getLogger().isLoggable(Level.FINEST)) {
                if (this instanceof OutboundWay) {
                    Context.getCurrentLogger().log(Level.FINER, "OutboundWay#setMessageState: " + (Object)((Object)messageState));
                } else {
                    Context.getCurrentLogger().log(Level.FINER, "InboundWay#setMessageState: " + (Object)((Object)messageState));
                }
            }
        }
    }

    protected void setRegistration(SelectionRegistration registration) {
        this.registration = registration;
    }

    public String toString() {
        return (Object)((Object)this.getIoState()) + ", " + (Object)((Object)this.getMessageState()) + ", " + this.getBuffer();
    }

    public void updateState() {
        if (this.hasIoInterest()) {
            this.setIoState(IoState.INTEREST);
        }
        this.getRegistration().setInterestOperations(this.getInterestOperations());
    }
}

