/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio;

import java.io.IOException;
import java.util.Iterator;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.ext.nio.ServerConnectionHelper;
import org.restlet.ext.nio.internal.connection.Connection;
import org.restlet.ext.nio.internal.request.HttpInboundRequest;
import org.restlet.ext.nio.internal.way.HttpServerInboundWay;
import org.restlet.ext.nio.internal.way.HttpServerOutboundWay;
import org.restlet.ext.nio.internal.way.InboundWay;
import org.restlet.ext.nio.internal.way.OutboundWay;

public class HttpServerHelper
extends ServerConnectionHelper {
    public HttpServerHelper(Server server) {
        this(server, Protocol.HTTP);
    }

    public HttpServerHelper(Server server, Protocol protocol) {
        super(server);
        this.getProtocols().add(protocol);
    }

    @Override
    protected boolean canHandle(Connection<Server> connection, Response response) throws IOException {
        boolean result = false;
        HttpServerInboundWay inboundWay = (HttpServerInboundWay)connection.getInboundWay();
        Response nextResponse = inboundWay.getMessages().peek();
        if (nextResponse != null) {
            if (nextResponse.getRequest() == response.getRequest()) {
                result = true;
            } else {
                boolean found = false;
                Iterator iterator = inboundWay.getMessages().iterator();
                while (iterator.hasNext() && !found) {
                    Response next = (Response)iterator.next();
                    found = next.getRequest() == response.getRequest();
                }
                if (!found) {
                    throw new IOException("Can't find the parent request in the list of inbound messages.");
                }
            }
        } else {
            throw new IOException("Can't find the parent request in the empty list of inbound messages.");
        }
        return result;
    }

    @Override
    public InboundWay createInboundWay(Connection<Server> connection, int bufferSize) {
        return new HttpServerInboundWay(connection, bufferSize);
    }

    @Override
    public OutboundWay createOutboundWay(Connection<Server> connection, int bufferSize) {
        return new HttpServerOutboundWay(connection, bufferSize);
    }

    @Override
    public Request createRequest(Connection<Server> connection, String methodName, String resourceUri, String protocol) {
        return new HttpInboundRequest(this.getContext(), connection, methodName, resourceUri, protocol);
    }
}

