/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio.internal.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.util.StringUtils;
import org.restlet.ext.nio.internal.channel.WrapperChannel;

public class ReadableChunkingChannel
extends WrapperChannel<ReadableByteChannel>
implements ReadableByteChannel {
    private final int chunkSizeLength;
    private boolean lastChunkWritten;

    public ReadableChunkingChannel(ReadableByteChannel source, int maxBufferSize) {
        super(source);
        this.chunkSizeLength = Integer.toHexString(maxBufferSize).length();
        this.lastChunkWritten = false;
    }

    private int fillChunkSizeString(int chunkDataSize, ByteBuffer targetBuffer) {
        int result = 0;
        String chunkDataSizeString = Integer.toHexString(chunkDataSize);
        result = chunkDataSizeString.length();
        for (int i = chunkDataSizeString.length(); i < this.chunkSizeLength; ++i) {
            targetBuffer.put((byte)48);
            ++result;
        }
        targetBuffer.put(StringUtils.getAsciiBytes((String)chunkDataSizeString));
        targetBuffer.put((byte)13);
        targetBuffer.put((byte)10);
        return result += 2;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int result = 0;
        boolean tryAgain = true;
        while (tryAgain) {
            if (this.lastChunkWritten) {
                result = -1;
                tryAgain = false;
                continue;
            }
            int chunkStart = dst.position();
            int maxChunkDataSize = dst.remaining() - this.chunkSizeLength - 4;
            int chunkDataSize = 0;
            if (maxChunkDataSize > 0) {
                dst.position(chunkStart + this.chunkSizeLength + 2);
                dst.limit(dst.position() + maxChunkDataSize);
                if (Context.getCurrentLogger().isLoggable(Level.FINER)) {
                    Context.getCurrentLogger().finer("Position in destination buffer before chunking | Limit | MaxChunkDataSize : " + dst.position() + " | " + dst.limit() + " | " + maxChunkDataSize);
                }
                chunkDataSize = ((ReadableByteChannel)this.getWrappedChannel()).read(dst);
                dst.limit(dst.capacity());
                if (chunkDataSize == -1) {
                    this.lastChunkWritten = true;
                    tryAgain = false;
                    dst.position(chunkStart);
                    result += this.fillChunkSizeString(0, dst);
                    dst.put((byte)13);
                    dst.put((byte)10);
                    result += 2;
                    continue;
                }
                if (chunkDataSize > 0) {
                    dst.put((byte)13);
                    dst.put((byte)10);
                    dst.position(chunkStart);
                    this.fillChunkSizeString(chunkDataSize, dst);
                    if (Context.getCurrentLogger().isLoggable(Level.FINER)) {
                        Context.getCurrentLogger().finer("Old chunking position in destination buffer | Limit | MaxChunkDataSize | ChunkDataSize : " + dst.position() + " | " + dst.limit() + " | " + maxChunkDataSize + " | " + chunkDataSize);
                    }
                    dst.position(dst.position() + chunkDataSize + 2);
                    if (Context.getCurrentLogger().isLoggable(Level.FINER)) {
                        Context.getCurrentLogger().finer("New chunking position in destination buffer | Limit | MaxChunkDataSize | ChunkDataSize : " + dst.position() + " | " + dst.limit() + " | " + maxChunkDataSize + " | " + chunkDataSize);
                    }
                    result += dst.position() - chunkStart;
                    continue;
                }
                dst.position(chunkStart);
                continue;
            }
            tryAgain = false;
        }
        return result;
    }
}

