/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import org.restlet.engine.io.IoUtils;
import org.restlet.engine.io.SelectorFactory;
import org.restlet.ext.nio.internal.channel.ChannelInputStream;

public class NioUtils {
    public static int copy(ByteBuffer sourceBuffer, ByteBuffer targetBuffer, long maxCopied) {
        int maxBuffer = Math.min(sourceBuffer.remaining(), targetBuffer.remaining());
        int result = maxCopied == 0L ? maxBuffer : Math.min((int)maxCopied, maxBuffer);
        for (int i = 0; i < result; ++i) {
            targetBuffer.put(sourceBuffer.get());
        }
        return result;
    }

    public static void copy(FileChannel fileChannel, WritableByteChannel writableChannel) throws IOException {
        long position = 0L;
        long count = fileChannel.size();
        long written = 0L;
        SelectableChannel selectableChannel = null;
        if (writableChannel instanceof SelectableChannel) {
            selectableChannel = (SelectableChannel)((Object)writableChannel);
        }
        while (count > 0L) {
            NioUtils.waitForState(selectableChannel, 4);
            written = fileChannel.transferTo(position, count, writableChannel);
            position += written;
            count -= written;
        }
    }

    public static void copy(ReadableByteChannel readableChannel, OutputStream outputStream) throws IOException {
        if (readableChannel != null && outputStream != null) {
            IoUtils.copy((InputStream)new ChannelInputStream(readableChannel), (OutputStream)outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForState(SelectableChannel selectableChannel, int operations) throws IOException {
        if (selectableChannel != null) {
            Selector selector = null;
            SelectionKey selectionKey = null;
            int selected = 0;
            try {
                selector = SelectorFactory.getSelector();
                while (selected == 0) {
                    selectionKey = selectableChannel.register(selector, operations);
                    selected = selector.select(IoUtils.TIMEOUT_MS);
                }
            }
            finally {
                IoUtils.release((Selector)selector, selectionKey);
            }
        }
    }

    private NioUtils() {
    }
}

