/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import java.security.Principal;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Role
implements Principal {
    public static final Role ALL = new Role("*", "Role that covers all existing roles."){

        public void setDescription(String description) {
            throw new IllegalStateException("Unmodifiable role");
        }

        public void setName(String name) {
            throw new IllegalStateException("Unmodifiable role");
        }
    };
    private final List<Role> childRoles;
    private volatile String description;
    private volatile String name;

    public Role() {
        this(null, null);
    }

    public Role(String name, String description) {
        this.name = name;
        this.description = description;
        this.childRoles = new CopyOnWriteArrayList<Role>();
    }

    public List<Role> getChildRoles() {
        return this.childRoles;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setChildRoles(List<Role> children) {
        this.childRoles.clear();
        if (children != null) {
            this.childRoles.addAll(children);
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

