/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.io.InputStreamChannel;
import org.restlet.representation.Representation;
import org.restlet.util.WrapperRepresentation;

public class BufferingRepresentation
extends WrapperRepresentation {
    private volatile byte[] buffer;
    private volatile boolean buffered;

    public BufferingRepresentation(Representation bufferedRepresentation) {
        super(bufferedRepresentation);
        this.setTransient(false);
    }

    private void buffer() throws IOException {
        if (!this.isBuffered() && this.getWrappedRepresentation().isAvailable()) {
            ByteArrayOutputStream bArray = new ByteArrayOutputStream();
            this.getWrappedRepresentation().write(bArray);
            this.setBuffer(bArray.toByteArray());
            this.setBuffered(true);
        }
    }

    public long getAvailableSize() {
        return this.getSize();
    }

    protected byte[] getBuffer() {
        return this.buffer;
    }

    public ReadableByteChannel getChannel() throws IOException {
        InputStream is = this.getStream();
        return is != null ? new InputStreamChannel(is) : null;
    }

    public long getSize() {
        try {
            this.buffer();
        }
        catch (IOException e) {
            Context.getCurrentLogger().log(Level.WARNING, "Unable to buffer the wrapped representation", e);
        }
        return this.getBuffer() != null ? (long)this.getBuffer().length : -1L;
    }

    public InputStream getStream() throws IOException {
        this.buffer();
        return this.getBuffer() != null ? new ByteArrayInputStream(this.getBuffer()) : null;
    }

    public String getText() throws IOException {
        this.buffer();
        return this.getBuffer() != null ? new String(this.getBuffer(), this.getCharacterSet().toCharset().name()) : null;
    }

    protected boolean isBuffered() {
        return this.buffered;
    }

    protected void setBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    protected void setBuffered(boolean buffered) {
        this.buffered = buffered;
    }

    public void write(OutputStream outputStream) throws IOException {
        this.buffer();
        outputStream.write(this.getBuffer());
    }

    public void write(Writer writer) throws IOException {
        this.buffer();
        if (this.getText() != null) {
            writer.write(this.getText());
        }
    }
}

