/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.Arrays;
import java.util.List;
import org.restlet.Connector;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.engine.Engine;
import org.restlet.engine.RestletHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client
extends Connector {
    private volatile int connectTimeout = 0;
    private final RestletHelper<Client> helper;

    public Client(Context context, List<Protocol> protocols) {
        this(context, protocols, null);
    }

    public Client(Context context, List<Protocol> protocols, String helperClass) {
        super(context, protocols);
        this.helper = protocols != null && protocols.size() > 0 ? (Engine.getInstance() != null ? Engine.getInstance().createHelper(this, helperClass) : null) : null;
        if (context != null && this.helper != null) {
            context.getAttributes().put("org.restlet.engine.helper", this.helper);
        }
    }

    public Client(Context context, Protocol protocol) {
        this(context, protocol == null ? null : Arrays.asList(protocol), null);
    }

    public Client(List<Protocol> protocols) {
        this(null, protocols, null);
    }

    public Client(Protocol protocol) {
        this(null, protocol);
    }

    public Client(String protocolName) {
        this(Protocol.valueOf(protocolName));
    }

    @Deprecated
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    private RestletHelper<Client> getHelper() {
        return this.helper;
    }

    public final Response handle(Request request) {
        Response response = new Response(request);
        this.handle(request, response);
        return response;
    }

    @Override
    public void handle(Request request, Response response) {
        super.handle(request, response);
        if (this.getHelper() != null) {
            this.getHelper().handle(request, response);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("No available client connector supports the required protocol: ");
            sb.append("'").append(request.getProtocol().getName()).append("'.");
            sb.append(" Please add the JAR of a matching connector to your classpath.");
            response.setStatus(Status.CONNECTOR_ERROR_INTERNAL, sb.toString());
        }
    }

    public void handle(Request request, Response response, Uniform onResponseCallback) {
        request.setOnResponse(onResponseCallback);
        this.handle(request, response);
    }

    public final void handle(Request request, Uniform onReceivedCallback) {
        Response response = new Response(request);
        this.handle(request, response, onReceivedCallback);
    }

    @Override
    public boolean isAvailable() {
        return this.getHelper() != null;
    }

    @Deprecated
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isStopped()) {
            super.start();
            if (this.getHelper() != null) {
                this.getHelper().start();
            }
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.isStarted()) {
            if (this.getHelper() != null) {
                this.getHelper().stop();
            }
            super.stop();
        }
    }
}

