/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.engine.ConnectorHelper;
import org.restlet.engine.adapter.Call;
import org.restlet.engine.adapter.HttpClientHelper;
import org.restlet.engine.header.Header;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.representation.Representation;
import org.restlet.service.ConnectorService;
import org.restlet.util.Series;

public abstract class ClientCall
extends Call {
    private volatile HttpClientHelper helper;

    public static String getLocalAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "127.0.0.1";
        }
    }

    public ClientCall(HttpClientHelper helper, String method, String requestUri) {
        this.helper = helper;
        this.setMethod(method);
        this.setRequestUri(requestUri);
        this.setClientAddress(ClientCall.getLocalAddress());
    }

    protected long getContentLength() {
        return HeaderUtils.getContentLength(this.getResponseHeaders());
    }

    public HttpClientHelper getHelper() {
        return this.helper;
    }

    public abstract WritableByteChannel getRequestEntityChannel();

    public abstract OutputStream getRequestEntityStream();

    public abstract OutputStream getRequestHeadStream();

    public Representation getResponseEntity(Response response) {
        Representation result = null;
        long size = -1L;
        Series<Header> responseHeaders = this.getResponseHeaders();
        String transferEncoding = responseHeaders.getFirstValue("Transfer-Encoding", true);
        size = transferEncoding != null && !"identity".equalsIgnoreCase(transferEncoding) ? -1L : this.getContentLength();
        if (!(this.getMethod().equals(Method.HEAD.getName()) || response.getStatus().isInformational() || response.getStatus().equals(Status.REDIRECTION_NOT_MODIFIED) || response.getStatus().equals(Status.SUCCESS_NO_CONTENT) || response.getStatus().equals(Status.SUCCESS_RESET_CONTENT))) {
            InputStream stream = this.getUnClosedResponseEntityStream(this.getResponseEntityStream(size));
            ReadableByteChannel channel = this.getResponseEntityChannel(size);
            if (stream != null) {
                result = this.getRepresentation(stream);
            } else if (channel != null) {
                result = this.getRepresentation(channel);
            }
        }
        if (result != null) {
            result.setSize(size);
            if (size == -1L) {
                this.getLogger().fine("The length of the message body is unknown. The entity must be handled carefully and consumed entirely in order to surely release the connection.");
            }
        }
        result = HeaderUtils.extractEntityHeaders(responseHeaders, result);
        return result;
    }

    public abstract ReadableByteChannel getResponseEntityChannel(long var1);

    public abstract InputStream getResponseEntityStream(long var1);

    private InputStream getUnClosedResponseEntityStream(InputStream inputStream) {
        InputStream result = null;
        if (inputStream != null) {
            try {
                if (inputStream.available() > 0) {
                    result = inputStream;
                } else {
                    PushbackInputStream is = new PushbackInputStream(inputStream);
                    int i = is.read();
                    if (i >= 0) {
                        is.unread(i);
                        result = is;
                    }
                }
            }
            catch (IOException ioe) {
                this.getLogger().log(Level.FINER, "End of response entity stream.", ioe);
            }
        }
        return result;
    }

    protected boolean isClientKeepAlive() {
        return true;
    }

    protected boolean isServerKeepAlive() {
        return !HeaderUtils.isConnectionClose(this.getResponseHeaders());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status sendRequest(Request request) {
        Status result = null;
        Representation entity = request.isEntityAvailable() ? request.getEntity() : null;
        ConnectorService connectorService = ConnectorHelper.getConnectorService();
        if (connectorService != null) {
            connectorService.beforeSend(entity);
        }
        try {
            if (entity != null) {
                OutputStream requestStream = this.getRequestEntityStream();
                WritableByteChannel requestChannel = this.getRequestEntityChannel();
                if (requestChannel != null) {
                    entity.write(requestChannel);
                    requestChannel.close();
                } else if (requestStream != null) {
                    entity.write(requestStream);
                    requestStream.flush();
                    requestStream.close();
                }
            }
            result = new Status(this.getStatusCode(), null, this.getReasonPhrase(), null);
        }
        catch (IOException ioe) {
            this.getHelper().getLogger().log(Level.FINE, "An error occured during the communication with the remote HTTP server.", ioe);
            result = new Status(Status.CONNECTOR_ERROR_COMMUNICATION, (Throwable)ioe);
        }
        finally {
            if (entity != null) {
                entity.release();
            }
            if (connectorService != null) {
                connectorService.afterSend(entity);
            }
        }
        return result;
    }

    public void sendRequest(Request request, Response response, Uniform callback) throws Exception {
        Context.getCurrentLogger().warning("Currently callbacks are not available for this connector.");
    }

    protected boolean shouldRequestBeChunked(Request request) {
        return request.isEntityAvailable() && request.getEntity() != null && request.getEntity().getSize() == -1L;
    }
}

