/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.io.IoUtils;
import org.restlet.representation.Representation;
import org.restlet.util.SelectionListener;

public abstract class InputListener
implements SelectionListener {
    private final ByteBuffer byteBuffer;
    private final ReadableByteChannel byteChannel;

    public InputListener(Representation source) throws IOException {
        this(source, IoUtils.BUFFER_SIZE);
    }

    public InputListener(Representation source, int bufferSize) throws IOException {
        this.byteBuffer = ByteBuffer.allocate(bufferSize);
        this.byteChannel = source.getChannel();
    }

    protected abstract void onContent(InputStream var1);

    protected void onEnd() {
    }

    protected void onError(IOException ioe) {
        Context.getCurrentLogger().log(Level.WARNING, "", ioe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSelected() {
        try {
            ByteBuffer byteBuffer = this.byteBuffer;
            synchronized (byteBuffer) {
                this.byteBuffer.clear();
                int result = this.byteChannel.read(this.byteBuffer);
                if (result > 0) {
                    this.byteBuffer.flip();
                    ByteArrayInputStream bais = new ByteArrayInputStream(this.byteBuffer.array(), this.byteBuffer.arrayOffset(), this.byteBuffer.remaining());
                    this.onContent(bais);
                } else if (result == -1) {
                    this.onEnd();
                } else {
                    Context.getCurrentLogger().fine("Input stream selection found with no content available");
                }
            }
        }
        catch (IOException ioe) {
            this.onError(ioe);
        }
    }
}

