/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import org.restlet.engine.io.IoUtils;
import org.restlet.engine.io.NioUtils;
import org.restlet.engine.io.SelectorFactory;

public class NbChannelOutputStream
extends OutputStream {
    private final ByteBuffer bb = ByteBuffer.allocate(IoUtils.BUFFER_SIZE);
    private final WritableByteChannel channel;
    private final SelectableChannel selectableChannel;
    private volatile SelectionKey selectionKey;
    private volatile Selector selector;

    public NbChannelOutputStream(WritableByteChannel channel) {
        this.selectableChannel = channel instanceof SelectableChannel ? (SelectableChannel)((Object)channel) : null;
        this.channel = channel;
        this.selector = null;
    }

    private void doWrite() throws IOException {
        if (this.channel != null && this.bb != null) {
            try {
                int attempts = 0;
                while (this.bb.hasRemaining()) {
                    int bytesWritten = this.channel.write(this.bb);
                    ++attempts;
                    if (bytesWritten < 0) {
                        throw new EOFException("Unexpected negative number of bytes written. End of file detected.");
                    }
                    if (bytesWritten == 0) {
                        if (this.selectableChannel == null) continue;
                        if (this.selector == null) {
                            this.selector = SelectorFactory.getSelector();
                        }
                        if (this.selector == null) {
                            if (attempts <= 2) continue;
                            throw new IOException("Unable to obtain a selector. Selector factory returned null.");
                        }
                        this.selectionKey = this.selectableChannel.register(this.selector, 4);
                        if (this.selector.select(IoUtils.TIMEOUT_MS) == 0) {
                            if (attempts <= 2) continue;
                            throw new IOException("Unable to select the channel to write to it. Selection timed out.");
                        }
                        --attempts;
                        continue;
                    }
                    attempts = 0;
                }
            }
            catch (IOException ioe) {
                throw new IOException("Unable to write to the non-blocking channel. " + ioe.getLocalizedMessage());
            }
            finally {
                this.bb.clear();
                NioUtils.release(this.selector, this.selectionKey);
            }
        } else {
            throw new IOException("Unable to write. Null byte buffer or channel detected.");
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        for (int index = 0; index < len; index += IoUtils.BUFFER_SIZE) {
            int size = len - index > IoUtils.BUFFER_SIZE ? IoUtils.BUFFER_SIZE : len - index;
            this.bb.clear();
            this.bb.put(b, index, size);
            this.bb.flip();
            this.doWrite();
        }
    }

    public void write(int b) throws IOException {
        this.bb.clear();
        this.bb.put((byte)b);
        this.bb.flip();
        this.doWrite();
    }
}

