/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.IOException;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.io.Buffer;
import org.restlet.engine.io.CompletionListener;
import org.restlet.engine.io.ReadableBufferedChannel;
import org.restlet.engine.io.ReadableSelectionChannel;
import org.restlet.engine.io.WakeupListener;

public class ReadableSizedSelectionChannel
extends ReadableBufferedChannel {
    private volatile long availableSize;

    public ReadableSizedSelectionChannel(CompletionListener completionListener, Buffer buffer, ReadableSelectionChannel source, long availableSize, WakeupListener wakeupListener) {
        super(completionListener, buffer, source, wakeupListener);
        this.availableSize = availableSize;
    }

    protected long getAvailableSize() {
        return this.availableSize;
    }

    @Override
    public int onDrain(Buffer buffer, int maxDrained, Object ... args) throws IOException {
        int result = 0;
        result = this.getAvailableSize() > 0L ? super.onDrain(buffer, (int)this.getAvailableSize(), args) : -1;
        if (result > 0) {
            this.setAvailableSize(this.getAvailableSize() - (long)result);
            if (Context.getCurrentLogger().isLoggable(Level.FINER)) {
                Context.getCurrentLogger().finer("Bytes (read | available) : " + result + " | " + this.getAvailableSize());
            }
            if (this.getAvailableSize() == 0L && Context.getCurrentLogger().isLoggable(Level.FINER)) {
                Context.getCurrentLogger().finer("Channel fully read.");
            }
        } else if (result == -1) {
            this.setEndReached(true);
        }
        return result;
    }

    protected void setAvailableSize(long availableSize) throws IOException {
        this.availableSize = availableSize;
        this.setEndReached(this.availableSize == 0L);
    }
}

