/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.representation;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.restlet.data.MediaType;
import org.restlet.representation.OutputRepresentation;
import org.restlet.representation.Representation;

public class ObjectRepresentation<T extends Serializable>
extends OutputRepresentation {
    private volatile T object;

    public ObjectRepresentation(Representation serializedRepresentation) throws IOException, ClassNotFoundException, IllegalArgumentException {
        super(MediaType.APPLICATION_JAVA_OBJECT);
        ObjectInputStream ois;
        if (serializedRepresentation.getMediaType().equals(MediaType.APPLICATION_JAVA_OBJECT)) {
            this.setMediaType(MediaType.APPLICATION_JAVA_OBJECT);
            InputStream is = serializedRepresentation.getStream();
            ois = new ObjectInputStream(is);
            this.object = (Serializable)ois.readObject();
            if (is.read() != -1) {
                throw new IOException("The input stream has not been fully read.");
            }
        } else {
            throw new IllegalArgumentException("The serialized representation must have this media type: " + MediaType.APPLICATION_JAVA_OBJECT.toString() + " or this one: " + MediaType.APPLICATION_JAVA_OBJECT_XML.toString());
        }
        ois.close();
    }

    public ObjectRepresentation(T object) {
        super(MediaType.APPLICATION_JAVA_OBJECT);
        this.object = object;
    }

    public ObjectRepresentation(T object, MediaType mediaType) {
        super(mediaType == null ? MediaType.APPLICATION_JAVA_OBJECT : mediaType);
        this.object = object;
    }

    public T getObject() throws IOException {
        return this.object;
    }

    @Override
    public void release() {
        this.setObject(null);
        super.release();
    }

    public void setObject(T object) {
        this.object = object;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        if (MediaType.APPLICATION_JAVA_OBJECT.isCompatible(this.getMediaType())) {
            ObjectOutputStream oos = new ObjectOutputStream(outputStream);
            oos.writeObject(this.getObject());
            oos.flush();
        }
    }
}

