/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.routing;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Cookie;
import org.restlet.data.Form;
import org.restlet.representation.Representation;
import org.restlet.routing.Filter;
import org.restlet.util.Series;

public class Extractor
extends Filter {
    private volatile List<ExtractInfo> cookieExtracts;
    private volatile List<ExtractInfo> entityExtracts;
    private volatile List<ExtractInfo> queryExtracts;

    public Extractor() {
        this(null);
    }

    public Extractor(Context context) {
        this(context, null);
    }

    public Extractor(Context context, Restlet next) {
        super(context, next);
    }

    @Override
    protected int beforeHandle(Request request, Response response) {
        Series<Cookie> cookies;
        Representation entity;
        String value;
        Form form;
        if (!this.getQueryExtracts().isEmpty() && (form = request.getResourceRef().getQueryAsForm()) != null) {
            for (ExtractInfo extractInfo : this.getQueryExtracts()) {
                if (extractInfo.first) {
                    value = form.getFirstValue(extractInfo.parameter);
                    if (value == null) continue;
                    request.getAttributes().put(extractInfo.attribute, value);
                    continue;
                }
                request.getAttributes().put(extractInfo.attribute, form.subList(extractInfo.parameter));
            }
        }
        if (!this.getEntityExtracts().isEmpty() && (entity = request.getEntity()) != null) {
            Form form2 = new Form(entity);
            for (ExtractInfo ei : this.getEntityExtracts()) {
                if (ei.first) {
                    String value2 = form2.getFirstValue(ei.parameter);
                    if (value2 == null) continue;
                    request.getAttributes().put(ei.attribute, value2);
                    continue;
                }
                request.getAttributes().put(ei.attribute, form2.subList(ei.parameter));
            }
        }
        if (!this.getCookieExtracts().isEmpty() && (cookies = request.getCookies()) != null) {
            for (ExtractInfo extractInfo : this.getCookieExtracts()) {
                if (extractInfo.first) {
                    value = cookies.getFirstValue(extractInfo.parameter);
                    if (value == null) continue;
                    request.getAttributes().put(extractInfo.attribute, value);
                    continue;
                }
                request.getAttributes().put(extractInfo.attribute, cookies.subList(extractInfo.parameter));
            }
        }
        return 0;
    }

    public void extractFromCookie(String attribute, String cookieName, boolean first) {
        this.getCookieExtracts().add(new ExtractInfo(attribute, cookieName, first));
    }

    public void extractFromEntity(String attribute, String parameter, boolean first) {
        this.getEntityExtracts().add(new ExtractInfo(attribute, parameter, first));
    }

    public void extractFromQuery(String attribute, String parameter, boolean first) {
        this.getQueryExtracts().add(new ExtractInfo(attribute, parameter, first));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ExtractInfo> getCookieExtracts() {
        List<ExtractInfo> ce = this.cookieExtracts;
        if (ce == null) {
            Extractor extractor = this;
            synchronized (extractor) {
                ce = this.cookieExtracts;
                if (ce == null) {
                    this.cookieExtracts = ce = new CopyOnWriteArrayList<ExtractInfo>();
                }
            }
        }
        return ce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ExtractInfo> getEntityExtracts() {
        List<ExtractInfo> ee = this.entityExtracts;
        if (ee == null) {
            Extractor extractor = this;
            synchronized (extractor) {
                ee = this.entityExtracts;
                if (ee == null) {
                    this.entityExtracts = ee = new CopyOnWriteArrayList<ExtractInfo>();
                }
            }
        }
        return ee;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ExtractInfo> getQueryExtracts() {
        List<ExtractInfo> qe = this.queryExtracts;
        if (qe == null) {
            Extractor extractor = this;
            synchronized (extractor) {
                qe = this.queryExtracts;
                if (qe == null) {
                    this.queryExtracts = qe = new CopyOnWriteArrayList<ExtractInfo>();
                }
            }
        }
        return qe;
    }

    private static final class ExtractInfo {
        protected String attribute;
        protected boolean first;
        protected String parameter;

        public ExtractInfo(String attribute, String parameter, boolean first) {
            this.attribute = attribute;
            this.parameter = parameter;
            this.first = first;
        }
    }
}

