/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.security.User;

public class Group {
    private volatile String description;
    private volatile boolean inheritingRoles;
    private final List<Group> memberGroups;
    private final List<User> memberUsers;
    private volatile String name;

    public Group() {
        this(null, null);
    }

    public Group(String name, String description) {
        this(name, description, true);
    }

    public Group(String name, String description, boolean inheritingRoles) {
        this.name = name;
        this.description = description;
        this.inheritingRoles = inheritingRoles;
        this.memberGroups = new CopyOnWriteArrayList<Group>();
        this.memberUsers = new CopyOnWriteArrayList<User>();
    }

    public String getDescription() {
        return this.description;
    }

    public List<Group> getMemberGroups() {
        return this.memberGroups;
    }

    public List<User> getMemberUsers() {
        return this.memberUsers;
    }

    public String getName() {
        return this.name;
    }

    public boolean isInheritingRoles() {
        return this.inheritingRoles;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setInheritingRoles(boolean inheritingRoles) {
        this.inheritingRoles = inheritingRoles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMemberGroups(List<Group> memberGroups) {
        List<Group> list = this.getMemberGroups();
        synchronized (list) {
            if (memberGroups != this.getMemberGroups()) {
                this.getMemberGroups().clear();
                if (memberGroups != null) {
                    this.getMemberGroups().addAll(memberGroups);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMemberUsers(List<User> memberUsers) {
        List<User> list = this.getMemberUsers();
        synchronized (list) {
            if (memberUsers != this.getMemberUsers()) {
                this.getMemberUsers().clear();
                if (memberUsers != null) {
                    this.getMemberUsers().addAll(memberUsers);
                }
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getName();
    }
}

