/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jackson;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import org.codehaus.jackson.map.ObjectMapper;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.representation.OutputRepresentation;
import org.restlet.representation.Representation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JacksonRepresentation<T>
extends OutputRepresentation {
    private T object;
    private Class<T> objectClass;
    private Representation representation;
    private ObjectMapper objectMapper;

    public JacksonRepresentation(MediaType mediaType, T object) {
        super(mediaType);
        this.object = object;
        this.objectClass = object == null ? null : object.getClass();
        this.representation = null;
        this.objectMapper = null;
    }

    public JacksonRepresentation(Representation representation, Class<T> objectClass) {
        super(representation.getMediaType());
        this.object = null;
        this.objectClass = objectClass;
        this.representation = representation;
        this.objectMapper = null;
    }

    protected ObjectMapper createObjectMapper(MediaType mediaType) {
        return new ObjectMapper();
    }

    public T getObject() {
        Object result = null;
        if (this.object != null) {
            result = this.object;
        } else if (this.representation != null) {
            try {
                result = this.getObjectMapper().readValue(this.representation.getStream(), this.objectClass);
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to parse the object with XStream.", e);
            }
        }
        return (T)result;
    }

    public Class<T> getObjectClass() {
        return this.objectClass;
    }

    public ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = this.createObjectMapper(this.getMediaType());
        }
        return this.objectMapper;
    }

    public void setObjectClass(Class<T> objectClass) {
        this.objectClass = objectClass;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.representation != null) {
            this.representation.write(outputStream);
        } else if (this.object != null) {
            this.getObjectMapper().writeValue(outputStream, this.object);
        }
    }
}

