/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.restlet.Client;
import org.restlet.data.Protocol;
import org.restlet.engine.RestletHelper;
import org.restlet.engine.ssl.SslContextFactory;
import org.restlet.engine.ssl.SslUtils;
import org.restlet.ext.nio.ClientConnectionHelper;
import org.restlet.ext.nio.internal.Connection;
import org.restlet.ext.nio.internal.ConnectionController;
import org.restlet.ext.nio.internal.HttpsClientInboundWay;
import org.restlet.ext.nio.internal.HttpsClientOutboundWay;
import org.restlet.ext.nio.internal.InboundWay;
import org.restlet.ext.nio.internal.OutboundWay;
import org.restlet.ext.nio.internal.SslConnection;

public class HttpsClientHelper
extends ClientConnectionHelper {
    private volatile SSLContext sslContext;

    public HttpsClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.HTTPS);
    }

    @Override
    public Connection<Client> createConnection(SocketChannel socketChannel, ConnectionController controller, InetSocketAddress socketAddress) throws IOException {
        SSLEngine engine = socketAddress != null ? this.getSslContext().createSSLEngine(socketAddress.getHostName(), socketAddress.getPort()) : this.getSslContext().createSSLEngine();
        return new SslConnection<Client>(this, socketChannel, controller, socketAddress, engine);
    }

    @Override
    public InboundWay createInboundWay(Connection<Client> connection, int bufferSize) {
        return new HttpsClientInboundWay(connection, bufferSize);
    }

    @Override
    public OutboundWay createOutboundWay(Connection<Client> connection, int bufferSize) {
        return new HttpsClientOutboundWay(connection, bufferSize);
    }

    protected SSLContext getSslContext() {
        return this.sslContext;
    }

    protected void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    @Override
    public synchronized void start() throws Exception {
        SslContextFactory factory = SslUtils.getSslContextFactory((RestletHelper)this);
        this.setSslContext(factory.createSslContext());
        super.start();
    }
}

