/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio.internal;

import java.io.IOException;
import java.util.logging.Level;
import org.restlet.Client;
import org.restlet.Message;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.engine.header.Header;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.engine.io.IoState;
import org.restlet.ext.nio.ClientConnectionHelper;
import org.restlet.ext.nio.internal.Connection;
import org.restlet.ext.nio.internal.ConnectionState;
import org.restlet.ext.nio.internal.InboundWay;
import org.restlet.ext.nio.internal.MessageState;
import org.restlet.util.Series;

public abstract class ClientInboundWay
extends InboundWay {
    public ClientInboundWay(Connection<?> connection, int bufferSize) {
        super(connection, bufferSize);
    }

    protected void copyResponseTransportHeaders(Series<Header> headers, Response response) {
        HeaderUtils.copyResponseTransportHeaders(headers, (Response)response);
    }

    protected abstract Response createResponse(Status var1);

    protected Status createStatus(int code) {
        return Status.valueOf((int)code);
    }

    @Override
    public Message getActualMessage() {
        return this.getMessage();
    }

    public Connection<Client> getConnection() {
        return super.getConnection();
    }

    public ClientConnectionHelper getHelper() {
        return (ClientConnectionHelper)super.getHelper();
    }

    @Override
    public int getInterestOperations() {
        int result = 0;
        result = this.getConnection().getState() == ConnectionState.OPENING ? 8 : super.getInterestOperations();
        return result;
    }

    @Override
    protected void onHeadersCompleted() throws IOException {
        super.onHeadersCompleted();
        this.getMessage().setEntity(this.createEntity(this.getHeaders()));
        try {
            this.copyResponseTransportHeaders(this.getHeaders(), this.getMessage());
        }
        catch (Throwable t) {
            this.getLogger().log(Level.WARNING, "Error while parsing the headers", t);
        }
        if (this.getHeaders() != null) {
            this.getMessage().getAttributes().put("org.restlet.http.headers", this.getHeaders());
        }
        this.onReceived(this.getMessage());
    }

    @Override
    public void onMessageCompleted(boolean endDetected) throws IOException {
        if (endDetected || !this.getConnection().isPersistent() || HeaderUtils.isConnectionClose(this.getHeaders())) {
            this.getConnection().close(true);
        }
        super.onMessageCompleted(endDetected);
    }

    @Override
    protected void onReceived(Response message) throws IOException {
        this.getHelper().getInboundMessages().add(this.getMessage());
        if (this.getMessage().isEntityAvailable()) {
            this.setIoState(IoState.IDLE);
        } else {
            this.onMessageCompleted(false);
        }
    }

    @Override
    protected void readStartLine() throws IOException {
        String version = null;
        int statusCode = -1;
        String reasonPhrase = null;
        int i = 0;
        int start = 0;
        int size = this.getLineBuilder().length();
        if (size != 0) {
            char next;
            for (i = start; version == null && i < size; ++i) {
                next = this.getLineBuilder().charAt(i);
                if (!HeaderUtils.isSpace((int)next)) continue;
                version = this.getLineBuilder().substring(start, i);
                start = i + 1;
            }
            for (i = start; statusCode == -1 && i < size; ++i) {
                next = this.getLineBuilder().charAt(i);
                if (!HeaderUtils.isSpace((int)next)) continue;
                try {
                    statusCode = Integer.parseInt(this.getLineBuilder().substring(start, i));
                }
                catch (NumberFormatException e) {
                    throw new IOException("Unable to parse the status code. Non numeric value: " + this.getLineBuilder().substring(start, i).toString());
                }
                start = i + 1;
            }
            if (statusCode == -1) {
                throw new IOException("Unable to parse the status code. End of line reached too early.");
            }
            for (i = start; reasonPhrase == null && i < size; ++i) {
                next = this.getLineBuilder().charAt(i);
            }
            if (i == size) {
                reasonPhrase = this.getLineBuilder().substring(start, i);
                start = i + 1;
            }
            if (reasonPhrase == null) {
                throw new IOException("Unable to parse the reason phrase. End of line reached too early.");
            }
            Status status = this.createStatus(statusCode);
            Response response = this.createResponse(status);
            response.setStatus(status, reasonPhrase);
            response.getServerInfo().setAddress(this.getConnection().getSocket().getLocalAddress().toString());
            response.getServerInfo().setAgent("Restlet-Framework/2.2rc2");
            response.getServerInfo().setPort(this.getConnection().getSocket().getPort());
            this.setMessage(response);
            this.setMessageState(MessageState.HEADERS);
            this.clearLineBuilder();
        }
    }
}

