/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio.internal;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.CacheDirective;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ClientInfo;
import org.restlet.data.Conditions;
import org.restlet.data.Cookie;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Range;
import org.restlet.data.RecipientInfo;
import org.restlet.data.Reference;
import org.restlet.data.Tag;
import org.restlet.data.Warning;
import org.restlet.engine.header.CacheDirectiveReader;
import org.restlet.engine.header.CookieReader;
import org.restlet.engine.header.ExpectationReader;
import org.restlet.engine.header.Header;
import org.restlet.engine.header.HeaderReader;
import org.restlet.engine.header.PreferenceReader;
import org.restlet.engine.header.RangeReader;
import org.restlet.engine.header.RecipientInfoReader;
import org.restlet.engine.header.WarningReader;
import org.restlet.engine.security.AuthenticatorUtils;
import org.restlet.engine.util.DateUtils;
import org.restlet.ext.nio.internal.Connection;
import org.restlet.ext.nio.internal.InboundRequest;
import org.restlet.util.Series;

public class HttpInboundRequest
extends Request
implements InboundRequest {
    private volatile boolean cacheDirectivesAdded;
    private volatile boolean clientAdded;
    private volatile boolean conditionAdded;
    private final Connection<Server> connection;
    private final Context context;
    private volatile boolean cookiesAdded;
    private volatile String protocol;
    private volatile boolean proxySecurityAdded;
    private volatile boolean rangesAdded;
    private volatile boolean recipientsInfoAdded;
    private volatile boolean referrerAdded;
    private volatile String resourceUri;
    private volatile boolean securityAdded;
    private final Principal userPrincipal;
    private volatile boolean warningsAdded;

    public static void addHeader(Request request, String headerName, String headerValue) {
        if (request instanceof HttpInboundRequest) {
            ((InboundRequest)request).getHeaders().add(headerName, headerValue);
        }
    }

    public HttpInboundRequest(Context context, Connection<Server> connection, String methodName, String resourceUri, String protocol) {
        this.connection = connection;
        this.context = context;
        this.userPrincipal = null;
        this.cacheDirectivesAdded = false;
        this.clientAdded = false;
        this.conditionAdded = false;
        this.cookiesAdded = false;
        this.proxySecurityAdded = false;
        this.rangesAdded = false;
        this.recipientsInfoAdded = false;
        this.referrerAdded = false;
        this.resourceUri = resourceUri;
        this.securityAdded = false;
        this.warningsAdded = false;
        int versionSeparator = protocol.indexOf(47);
        Protocol connectorProtocol = (Protocol)((Server)this.getConnection().getHelper().getHelped()).getProtocols().get(0);
        if (versionSeparator != -1) {
            String name = protocol.substring(0, versionSeparator);
            String version = protocol.substring(versionSeparator + 1);
            if (connectorProtocol.getTechnicalName().equals(name) && connectorProtocol.getVersion().equals(version)) {
                this.setProtocol(connectorProtocol);
            } else {
                this.setProtocol(Protocol.valueOf((String)name, (String)version));
            }
        }
        this.setMethod(Method.valueOf((String)methodName));
    }

    public HttpInboundRequest(HttpInboundRequest request) {
        super((Request)request);
        this.connection = request.getConnection();
        this.context = request.context;
        this.userPrincipal = request.getUserPrincipal();
    }

    public boolean abort() {
        this.getConnection().close(false);
        return true;
    }

    public void flushBuffers() {
        this.getConnection().getOutboundWay().flushBuffer();
    }

    public synchronized void commit(Response response) {
        if (response != null && !response.isCommitted()) {
            this.getConnection().commit(response);
            response.setCommitted(true);
        }
    }

    public List<CacheDirective> getCacheDirectives() {
        List result = super.getCacheDirectives();
        if (!this.cacheDirectivesAdded) {
            if (this.getHeaders() != null) {
                for (Header header : this.getHeaders().subList("Cache-Control")) {
                    CacheDirectiveReader.addValues((Header)header, (Collection)result);
                }
            }
            this.cacheDirectivesAdded = true;
        }
        return result;
    }

    public ChallengeResponse getChallengeResponse() {
        ChallengeResponse result = super.getChallengeResponse();
        if (!this.securityAdded) {
            if (this.getHeaders() != null) {
                String authorization = this.getHeaders().getValues("Authorization");
                result = AuthenticatorUtils.parseResponse((Request)this, (String)authorization, this.getHeaders());
                this.setChallengeResponse(result);
            }
            this.securityAdded = true;
        }
        return result;
    }

    public ClientInfo getClientInfo() {
        ClientInfo result = super.getClientInfo();
        if (!this.clientAdded) {
            if (this.getHeaders() != null) {
                String header;
                boolean useForwardedForHeader;
                String acceptMediaType = this.getHeaders().getValues("Accept");
                String acceptCharset = this.getHeaders().getValues("Accept-Charset");
                String acceptEncoding = this.getHeaders().getValues("Accept-Encoding");
                String acceptLanguage = this.getHeaders().getValues("Accept-Language");
                String acceptPatch = this.getHeaders().getValues("Accept-Patch");
                String expect = this.getHeaders().getValues("Expect");
                try {
                    PreferenceReader.addCharacterSets((String)acceptCharset, (ClientInfo)result);
                }
                catch (Exception e) {
                    this.context.getLogger().log(Level.INFO, e.getMessage());
                }
                try {
                    PreferenceReader.addEncodings((String)acceptEncoding, (ClientInfo)result);
                }
                catch (Exception e) {
                    this.context.getLogger().log(Level.INFO, e.getMessage());
                }
                try {
                    PreferenceReader.addLanguages((String)acceptLanguage, (ClientInfo)result);
                }
                catch (Exception e) {
                    this.context.getLogger().log(Level.INFO, e.getMessage());
                }
                try {
                    PreferenceReader.addMediaTypes((String)acceptMediaType, (ClientInfo)result);
                }
                catch (Exception e) {
                    this.context.getLogger().log(Level.INFO, e.getMessage());
                }
                try {
                    PreferenceReader.addPatches((String)acceptPatch, (ClientInfo)result);
                }
                catch (Exception e) {
                    this.context.getLogger().log(Level.INFO, e.getMessage());
                }
                try {
                    ExpectationReader.addValues((String)expect, (ClientInfo)result);
                }
                catch (Exception e) {
                    this.context.getLogger().log(Level.INFO, e.getMessage());
                }
                result.setAgent(this.getHeaders().getValues("User-Agent"));
                result.setFrom(this.getHeaders().getFirstValue("From", true));
                result.setAddress(this.getConnection().getAddress());
                result.setPort(this.getConnection().getPort());
                if (this.userPrincipal != null) {
                    result.getPrincipals().add(this.userPrincipal);
                }
                if (this.context != null && (useForwardedForHeader = Boolean.parseBoolean(this.context.getParameters().getFirstValue("useForwardedForHeader", false))) && (header = this.getHeaders().getValues("X-Forwarded-For")) != null) {
                    String[] addresses = header.split(",");
                    for (int i = 0; i < addresses.length; ++i) {
                        String address = addresses[i].trim();
                        result.getForwardedAddresses().add(address);
                    }
                }
            }
            this.clientAdded = true;
        }
        return result;
    }

    public Conditions getConditions() {
        Conditions result = super.getConditions();
        if (!this.conditionAdded) {
            if (this.getHeaders() != null) {
                String ifMatchHeader = this.getHeaders().getValues("If-Match");
                String ifNoneMatchHeader = this.getHeaders().getValues("If-None-Match");
                Date ifModifiedSince = null;
                Date ifUnmodifiedSince = null;
                String ifRangeHeader = this.getHeaders().getFirstValue("If-Range", true);
                for (Header header : this.getHeaders()) {
                    if (header.getName().equalsIgnoreCase("If-Modified-Since")) {
                        ifModifiedSince = HeaderReader.readDate((String)header.getValue(), (boolean)false);
                        continue;
                    }
                    if (!header.getName().equalsIgnoreCase("If-Unmodified-Since")) continue;
                    ifUnmodifiedSince = HeaderReader.readDate((String)header.getValue(), (boolean)false);
                }
                if (ifModifiedSince != null && ifModifiedSince.getTime() != -1L) {
                    result.setModifiedSince(ifModifiedSince);
                }
                if (ifUnmodifiedSince != null && ifUnmodifiedSince.getTime() != -1L) {
                    result.setUnmodifiedSince(ifUnmodifiedSince);
                }
                ArrayList<Tag> match = null;
                Tag current = null;
                if (ifMatchHeader != null) {
                    try {
                        HeaderReader hr = new HeaderReader(ifMatchHeader);
                        String value = hr.readRawValue();
                        while (value != null) {
                            current = Tag.parse((String)value);
                            if (match == null) {
                                match = new ArrayList<Tag>();
                                result.setMatch(match);
                            }
                            match.add(current);
                            value = hr.readRawValue();
                        }
                    }
                    catch (Exception e) {
                        this.context.getLogger().log(Level.INFO, "Unable to process the if-match header: " + ifMatchHeader);
                    }
                }
                ArrayList<Tag> noneMatch = null;
                if (ifNoneMatchHeader != null) {
                    try {
                        HeaderReader hr = new HeaderReader(ifNoneMatchHeader);
                        String value = hr.readRawValue();
                        while (value != null) {
                            current = Tag.parse((String)value);
                            if (noneMatch == null) {
                                noneMatch = new ArrayList<Tag>();
                                result.setNoneMatch(noneMatch);
                            }
                            noneMatch.add(current);
                            value = hr.readRawValue();
                        }
                    }
                    catch (Exception e) {
                        this.context.getLogger().log(Level.INFO, "Unable to process the if-none-match header: " + ifNoneMatchHeader);
                    }
                }
                if (ifRangeHeader != null && ifRangeHeader.length() > 0) {
                    Tag tag = Tag.parse((String)ifRangeHeader);
                    if (tag != null) {
                        result.setRangeTag(tag);
                    } else {
                        Date date = HeaderReader.readDate((String)ifRangeHeader, (boolean)false);
                        result.setRangeDate(date);
                    }
                }
            }
            this.conditionAdded = true;
        }
        return result;
    }

    @Override
    public Connection<Server> getConnection() {
        return this.connection;
    }

    public Series<Cookie> getCookies() {
        Series result = super.getCookies();
        if (!this.cookiesAdded) {
            String cookieValues;
            if (this.getHeaders() != null && (cookieValues = this.getHeaders().getValues("Cookie")) != null) {
                new CookieReader(cookieValues).addValues((Collection)result);
            }
            this.cookiesAdded = true;
        }
        return result;
    }

    @Override
    public Series<Header> getHeaders() {
        return (Series)this.getAttributes().get("org.restlet.http.headers");
    }

    public ChallengeResponse getProxyChallengeResponse() {
        ChallengeResponse result = super.getProxyChallengeResponse();
        if (!this.proxySecurityAdded) {
            if (this.getHeaders() != null) {
                String authorization = this.getHeaders().getValues("Proxy-Authorization");
                result = AuthenticatorUtils.parseResponse((Request)this, (String)authorization, this.getHeaders());
                this.setProxyChallengeResponse(result);
            }
            this.proxySecurityAdded = true;
        }
        return result;
    }

    public List<Range> getRanges() {
        List result = super.getRanges();
        if (!this.rangesAdded) {
            if (this.getHeaders() != null) {
                String ranges = this.getHeaders().getValues("Range");
                result.addAll(RangeReader.read((String)ranges));
            }
            this.rangesAdded = true;
        }
        return result;
    }

    public List<RecipientInfo> getRecipientsInfo() {
        List result = super.getRecipientsInfo();
        if (!this.recipientsInfoAdded && this.getHeaders() != null) {
            for (String header : this.getHeaders().getValuesArray("Via", true)) {
                new RecipientInfoReader(header).addValues((Collection)result);
            }
            this.setRecipientsInfo(result);
        }
        return result;
    }

    public Reference getReferrerRef() {
        if (!this.referrerAdded) {
            String referrerValue;
            if (this.getHeaders() != null && (referrerValue = this.getHeaders().getValues("Referer")) != null) {
                this.setReferrerRef(new Reference(referrerValue));
            }
            this.referrerAdded = true;
        }
        return super.getReferrerRef();
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public List<Warning> getWarnings() {
        List result = super.getWarnings();
        if (!this.warningsAdded) {
            if (this.getHeaders() != null) {
                for (String warning : this.getHeaders().getValuesArray("Warning", true)) {
                    new WarningReader(warning).addValues((Collection)result);
                }
            }
            this.warningsAdded = true;
        }
        return result;
    }

    public void setChallengeResponse(ChallengeResponse response) {
        super.setChallengeResponse(response);
        this.securityAdded = true;
    }

    @Override
    public void setHeaders(Series<Header> headers) {
        String maxForwardsHeader;
        this.getAttributes().put("org.restlet.http.headers", headers);
        if (this.protocol != null) {
            int slashIndex = this.protocol.indexOf(47);
            this.protocol = slashIndex != -1 ? this.protocol.substring(slashIndex + 1) : null;
        }
        String host = this.getHeaders() == null ? null : this.getHeaders().getFirstValue("Host", true);
        String hostDomain = null;
        int hostPort = -1;
        if (host != null) {
            boolean ipv4;
            int rightSquareBracketIndex = host.indexOf(93);
            boolean bl = ipv4 = rightSquareBracketIndex == -1;
            if (ipv4) {
                int colonIndex = host.indexOf(58);
                if (colonIndex != -1) {
                    hostDomain = host.substring(0, colonIndex);
                    hostPort = Integer.valueOf(host.substring(colonIndex + 1));
                } else {
                    hostDomain = host;
                    hostPort = this.getProtocol().getDefaultPort();
                }
                Context.getCurrentLogger().fine("HttpInboundRequest::setHeaders, IPv4 hostDomain: " + hostDomain + ", hostPort: " + hostPort);
            } else {
                if (rightSquareBracketIndex + 1 < host.length()) {
                    hostDomain = host.substring(0, rightSquareBracketIndex + 1);
                    hostPort = Integer.valueOf(host.substring(rightSquareBracketIndex + 2));
                } else if (rightSquareBracketIndex + 1 == host.length()) {
                    hostDomain = host;
                    hostPort = this.getProtocol().getDefaultPort();
                }
                Context.getCurrentLogger().fine("HttpInboundRequest::setHeaders, IPv6 hostDomain: " + hostDomain + ", hostPort: " + hostPort);
            }
        } else {
            Protocol serverProtocol = (Protocol)((Server)this.getConnection().getHelper().getHelped()).getProtocols().get(0);
            if (!Protocol.SIP.getSchemeName().equals(serverProtocol.getSchemeName()) && !Protocol.SIPS.getSchemeName().equals(serverProtocol.getSchemeName())) {
                Context.getCurrentLogger().info("Couldn't find the mandatory \"Host\" HTTP header. Falling back to the IP address.");
                hostDomain = this.getConnection().getAddress();
                hostPort = this.getConnection().getPort();
                if (hostDomain == null) {
                    hostDomain = "localhost";
                }
                if (hostPort == -1) {
                    hostPort = ((Server)this.getConnection().getHelper().getHelped()).getActualPort();
                }
                if (hostPort == -1) {
                    this.getProtocol().getDefaultPort();
                }
            }
        }
        Protocol protocol = (Protocol)((Server)this.getConnection().getHelper().getHelped()).getProtocols().get(0);
        StringBuilder sb = new StringBuilder();
        sb.append(protocol.getSchemeName()).append("://");
        sb.append(hostDomain);
        if (hostPort != -1 && hostPort != protocol.getDefaultPort()) {
            sb.append(':').append(hostPort);
        }
        this.setHostRef(sb.toString());
        if (this.resourceUri != null) {
            this.setResourceRef(new Reference(this.getHostRef(), this.resourceUri));
            if (this.getResourceRef().isRelative()) {
                if (!this.resourceUri.startsWith("/")) {
                    this.setResourceRef(new Reference(this.getHostRef().toString() + "/" + this.resourceUri));
                } else {
                    this.setResourceRef(new Reference(this.getHostRef().toString() + this.resourceUri));
                }
            }
            this.setOriginalRef(this.getResourceRef().getTargetRef());
        }
        String dateHeader = this.getHeaders() == null ? null : this.getHeaders().getFirstValue("Date", true);
        Date date = null;
        if (dateHeader != null) {
            date = DateUtils.parse((String)dateHeader);
        }
        if (date == null) {
            date = new Date();
        }
        this.setDate(date);
        String string = maxForwardsHeader = this.getHeaders() == null ? null : this.getHeaders().getFirstValue("Max-Forwards", true);
        if (maxForwardsHeader != null) {
            try {
                this.setMaxForwards(Integer.parseInt(maxForwardsHeader));
            }
            catch (NumberFormatException nfe) {
                Context.getCurrentLogger().info("Unable to parse the Max-Forwards header: " + maxForwardsHeader);
            }
        }
    }

    public void setProxyChallengeResponse(ChallengeResponse response) {
        super.setProxyChallengeResponse(response);
        this.proxySecurityAdded = true;
    }

    public void setRecipientsInfo(List<RecipientInfo> recipientsInfo) {
        super.setRecipientsInfo(recipientsInfo);
        this.recipientsInfoAdded = true;
    }

    public void setWarnings(List<Warning> warnings) {
        super.setWarnings(warnings);
        this.warningsAdded = true;
    }
}

