/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio.internal;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.Status;
import org.restlet.ext.nio.internal.Connection;
import org.restlet.ext.nio.internal.ServerInboundWay;

public class HttpServerInboundWay
extends ServerInboundWay {
    private final Queue<Response> messages = new ConcurrentLinkedQueue<Response>();

    public HttpServerInboundWay(Connection<Server> connection, int bufferSize) {
        super(connection, bufferSize);
    }

    @Override
    public void clear() {
        super.clear();
        this.messages.clear();
    }

    @Override
    protected Response createResponse(Request request) {
        return new Response(request);
    }

    @Override
    public int getLoadScore() {
        return this.getMessages().size();
    }

    public Queue<Response> getMessages() {
        return this.messages;
    }

    @Override
    protected boolean hasIoInterest() {
        return super.hasIoInterest() || this.isAvailable();
    }

    @Override
    public boolean isAvailable() {
        return super.isAvailable() && this.getMessages().isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.getMessages().isEmpty();
    }

    @Override
    public void onError(Status status) {
        for (Response rsp : this.getMessages()) {
            if (rsp == this.getMessage()) continue;
            this.getMessages().remove(rsp);
            this.getHelper().onInboundError(status, rsp);
        }
        super.onError(status);
    }

    @Override
    protected void onReceived(Response message) throws IOException {
        if (message.getRequest() != null && message.getRequest().isExpectingResponse()) {
            this.getMessages().add(message);
        }
        super.onReceived(message);
    }

    @Override
    public void onTimeOut() {
        for (Response rsp : this.getMessages()) {
            if (rsp == this.getMessage()) continue;
            this.getMessages().remove(rsp);
            this.getHelper().onInboundError(Status.CONNECTOR_ERROR_COMMUNICATION, rsp);
        }
        super.onTimeOut();
    }
}

