/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio.internal;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.Status;
import org.restlet.engine.io.IoState;
import org.restlet.ext.nio.internal.Connection;
import org.restlet.ext.nio.internal.HttpServerInboundWay;
import org.restlet.ext.nio.internal.ServerOutboundWay;

public class HttpServerOutboundWay
extends ServerOutboundWay {
    private final Queue<Response> messages = new ConcurrentLinkedQueue<Response>();

    public HttpServerOutboundWay(Connection<Server> connection, int bufferSize) {
        super(connection, bufferSize);
    }

    @Override
    public void clear() {
        super.clear();
        this.messages.clear();
    }

    @Override
    public int getLoadScore() {
        return this.getMessages().size();
    }

    public Queue<Response> getMessages() {
        return this.messages;
    }

    @Override
    public void handle(Response response) {
        this.getMessages().add(response);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.getMessages().isEmpty();
    }

    @Override
    public void onMessageCompleted(boolean endDetected) throws IOException {
        Queue<Response> inboundMessages;
        Response inboundMessage;
        this.getMessages().remove(this.getMessage());
        if (!this.getMessage().getStatus().isInformational() && (inboundMessage = (inboundMessages = ((HttpServerInboundWay)this.getConnection().getInboundWay()).getMessages()).peek()).getRequest() == this.getMessage().getRequest()) {
            inboundMessages.remove(inboundMessage);
        }
        super.onMessageCompleted(endDetected);
    }

    @Override
    public void onError(Status status) {
        for (Response rsp : this.getMessages()) {
            if (rsp == this.getMessage()) continue;
            this.getMessages().remove(rsp);
            this.getHelper().onOutboundError(status, rsp);
        }
        super.onError(status);
    }

    @Override
    public void onTimeOut() {
        for (Response rsp : this.getMessages()) {
            if (rsp == this.getMessage()) continue;
            this.getMessages().remove(rsp);
            this.getHelper().onOutboundError(Status.CONNECTOR_ERROR_COMMUNICATION, rsp);
        }
        super.onTimeOut();
    }

    @Override
    public void updateState() {
        if (this.getIoState() == IoState.IDLE && this.getMessage() == null) {
            this.setMessage(this.getMessages().peek());
        }
        super.updateState();
    }
}

