/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import javax.net.ssl.SSLEngineResult;
import org.restlet.Context;
import org.restlet.engine.io.Buffer;
import org.restlet.engine.io.IoState;
import org.restlet.engine.io.ReadableBufferedChannel;
import org.restlet.engine.io.ReadableSelectionChannel;
import org.restlet.engine.io.WakeupListener;
import org.restlet.ext.nio.internal.MessageState;
import org.restlet.ext.nio.internal.SslConnection;
import org.restlet.ext.nio.internal.TasksListener;

public class ReadableSslChannel
extends ReadableBufferedChannel
implements TasksListener {
    private final SslConnection<?> connection;

    public ReadableSslChannel(ReadableSelectionChannel source, SslConnection<?> connection, WakeupListener wakeupListener) {
        super(null, new Buffer(connection.getPacketBufferSize(), connection.getHelper().isDirectBuffers()), source, wakeupListener);
        if (Context.getCurrentLogger().isLoggable(Level.FINER)) {
            Context.getCurrentLogger().log(Level.FINER, "ReadableSslChannel created from: " + source + ". Registration: " + this.getRegistration());
        }
        this.connection = connection;
    }

    protected SslConnection<?> getConnection() {
        return this.connection;
    }

    @Override
    public void onCompleted() {
        if (this.getConnection().getInboundWay().getMessageState() == MessageState.START && this.getConnection().getInboundWay().getIoState() == IoState.IDLE) {
            this.getConnection().getInboundWay().setIoState(IoState.READY);
        }
    }

    public int onDrain(Buffer buffer, int maxDrained, Object ... args) throws IOException {
        ByteBuffer applicationBuffer = (ByteBuffer)args[0];
        int initialSize = buffer.remaining();
        SSLEngineResult sslResult = this.getConnection().getSslEngine().unwrap(buffer.getBytes(), applicationBuffer);
        this.getConnection().setSslResult(sslResult);
        return initialSize - buffer.remaining();
    }

    public void postProcess(int drained) throws IOException {
        this.getConnection().handleSslResult();
    }
}

