/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.restlet.Request;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.engine.RestletHelper;
import org.restlet.engine.ssl.SslContextFactory;
import org.restlet.engine.ssl.SslUtils;
import org.restlet.ext.nio.HttpServerHelper;
import org.restlet.ext.nio.internal.Connection;
import org.restlet.ext.nio.internal.ConnectionController;
import org.restlet.ext.nio.internal.HttpsInboundRequest;
import org.restlet.ext.nio.internal.HttpsServerInboundWay;
import org.restlet.ext.nio.internal.HttpsServerOutboundWay;
import org.restlet.ext.nio.internal.InboundWay;
import org.restlet.ext.nio.internal.OutboundWay;
import org.restlet.ext.nio.internal.SslConnection;

public class HttpsServerHelper
extends HttpServerHelper {
    private volatile SSLContext sslContext;

    public HttpsServerHelper(Server server) {
        super(server, Protocol.HTTPS);
    }

    @Override
    public Connection<Server> createConnection(SocketChannel socketChannel, ConnectionController controller, InetSocketAddress socketAddress) throws IOException {
        SSLEngine engine = socketAddress != null ? this.getSslContext().createSSLEngine(socketAddress.getHostName(), socketAddress.getPort()) : this.getSslContext().createSSLEngine();
        return new SslConnection<Server>(this, socketChannel, controller, socketAddress, engine);
    }

    @Override
    public InboundWay createInboundWay(Connection<Server> connection, int bufferSize) {
        return new HttpsServerInboundWay(connection, bufferSize);
    }

    @Override
    public OutboundWay createOutboundWay(Connection<Server> connection, int bufferSize) {
        return new HttpsServerOutboundWay(connection, bufferSize);
    }

    @Override
    public Request createRequest(Connection<Server> connection, String methodName, String resourceUri, String protocol) {
        return new HttpsInboundRequest(this.getContext(), connection, methodName, resourceUri, protocol);
    }

    protected SSLContext getSslContext() {
        return this.sslContext;
    }

    protected void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    @Override
    public synchronized void start() throws Exception {
        SslContextFactory factory = SslUtils.getSslContextFactory((RestletHelper)this);
        this.setSslContext(factory.createSslContext());
        super.start();
    }
}

