/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio.internal;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.restlet.Client;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.engine.io.IoState;
import org.restlet.ext.nio.internal.ClientInboundWay;
import org.restlet.ext.nio.internal.Connection;
import org.restlet.ext.nio.internal.MessageState;

public class HttpClientInboundWay
extends ClientInboundWay {
    private final Queue<Response> messages = new ConcurrentLinkedQueue<Response>();

    public HttpClientInboundWay(Connection<Client> connection, int bufferSize) {
        super(connection, bufferSize);
    }

    @Override
    public void clear() {
        super.clear();
        this.messages.clear();
    }

    @Override
    protected Response createResponse(Status status) {
        Response result = null;
        Response finalResponse = this.getMessages().peek();
        result = status.isInformational() ? new Response(finalResponse.getRequest()) : finalResponse;
        return result;
    }

    @Override
    public int getLoadScore() {
        return this.getMessages().size();
    }

    public Queue<Response> getMessages() {
        return this.messages;
    }

    @Override
    protected boolean hasIoInterest() {
        return this.getMessageState() == MessageState.START || this.getIoState() == IoState.IDLE && this.getMessageState() != MessageState.BODY && !this.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.getMessages().isEmpty();
    }

    @Override
    public void onMessageCompleted(boolean endDetected) throws IOException {
        this.getMessages().remove(this.getMessage());
        super.onMessageCompleted(endDetected);
    }

    @Override
    public void onError(Status status) {
        for (Response rsp : this.getMessages()) {
            if (rsp == this.getMessage()) continue;
            this.getMessages().remove(rsp);
            this.getHelper().onInboundError(status, rsp);
        }
        super.onError(status);
    }

    @Override
    public void onTimeOut() {
        for (Response rsp : this.getMessages()) {
            if (rsp == this.getMessage()) continue;
            this.getMessages().remove(rsp);
            this.getHelper().onInboundError(Status.CONNECTOR_ERROR_COMMUNICATION, rsp);
        }
        super.onTimeOut();
    }
}

