/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio.internal;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.ext.nio.internal.ClientOutboundWay;
import org.restlet.ext.nio.internal.Connection;
import org.restlet.ext.nio.internal.HttpClientInboundWay;
import org.restlet.ext.nio.internal.MessageState;

public class HttpClientOutboundWay
extends ClientOutboundWay {
    private final Queue<Response> messages = new ConcurrentLinkedQueue<Response>();

    public HttpClientOutboundWay(Connection<?> connection, int bufferSize) {
        super(connection, bufferSize);
    }

    @Override
    public void clear() {
        super.clear();
        this.messages.clear();
    }

    @Override
    public int getLoadScore() {
        return this.getMessages().size();
    }

    public Queue<Response> getMessages() {
        return this.messages;
    }

    @Override
    public void handle(Response response) {
        this.getMessages().add(response);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.getMessages().isEmpty();
    }

    @Override
    public void onError(Status status) {
        for (Response rsp : this.getMessages()) {
            if (rsp == this.getMessage()) continue;
            this.getMessages().remove(rsp);
            this.getHelper().onOutboundError(status, rsp);
        }
        super.onError(status);
    }

    @Override
    public void onHeadersCompleted() throws IOException {
        Request request;
        Response message = this.getMessage();
        if (message != null && (request = message.getRequest()).isExpectingResponse()) {
            Queue<Response> inboundMessages = ((HttpClientInboundWay)this.getConnection().getInboundWay()).getMessages();
            inboundMessages.add(message);
            this.getConnection().getInboundWay().setMessageState(MessageState.START);
        }
        super.onHeadersCompleted();
    }

    @Override
    public void onMessageCompleted(boolean endDetected) throws IOException {
        Response message = this.getMessage();
        if (message != null) {
            this.getMessages().remove(message);
            super.onMessageCompleted(endDetected);
        }
    }

    @Override
    public void onTimeOut() {
        for (Response rsp : this.getMessages()) {
            if (rsp == this.getMessage()) continue;
            this.getMessages().remove(rsp);
            this.getHelper().onOutboundError(Status.CONNECTOR_ERROR_COMMUNICATION, rsp);
        }
        super.onTimeOut();
    }

    @Override
    public void updateState() {
        if (this.getMessage() == null && this.getConnection().getInboundWay().isAvailable()) {
            this.setMessage(this.getMessages().peek());
        }
        super.updateState();
    }
}

