/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio.internal;

import java.security.cert.Certificate;
import java.util.List;
import org.restlet.Context;
import org.restlet.Server;
import org.restlet.ext.nio.internal.Connection;
import org.restlet.ext.nio.internal.HttpInboundRequest;
import org.restlet.ext.nio.internal.SslConnection;

public class HttpsInboundRequest
extends HttpInboundRequest {
    public HttpsInboundRequest(Context context, Connection<Server> connection, String methodName, String resourceUri, String protocol) {
        super(context, connection, methodName, resourceUri, protocol);
        Integer keySize;
        String cipherSuite;
        List<Certificate> clientCertificates = ((SslConnection)this.getConnection()).getSslClientCertificates();
        if (clientCertificates != null) {
            this.getClientInfo().setCertificates(clientCertificates);
        }
        if ((cipherSuite = ((SslConnection)this.getConnection()).getSslCipherSuite()) != null) {
            this.getClientInfo().setCipherSuite(cipherSuite);
        }
        if ((keySize = ((SslConnection)this.getConnection()).getSslKeySize()) != null) {
            this.getAttributes().put("org.restlet.https.keySize", keySize);
        }
    }

    public SslConnection<Server> getConnection() {
        return (SslConnection)super.getConnection();
    }
}

