/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.servlet.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.engine.http.HttpCall;
import org.restlet.engine.http.HttpRequest;
import org.restlet.engine.http.HttpServerCall;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletCall
extends HttpServerCall {
    private volatile HttpServletRequest request;
    private volatile Series<Parameter> requestHeaders;
    private volatile HttpServletResponse response;

    public static HttpServletRequest getRequest(Request request) {
        HttpCall httpCall;
        HttpServletRequest result = null;
        if (request instanceof HttpRequest && (httpCall = ((HttpRequest)request).getHttpCall()) instanceof ServletCall) {
            result = ((ServletCall)httpCall).getRequest();
        }
        return result;
    }

    public ServletCall(Server server, HttpServletRequest request, HttpServletResponse response) {
        super(server);
        this.request = request;
        this.response = response;
    }

    public ServletCall(String serverAddress, int serverPort, HttpServletRequest request, HttpServletResponse response) {
        super(serverAddress, serverPort);
        this.request = request;
        this.response = response;
    }

    public String getClientAddress() {
        return this.getRequest().getRemoteAddr();
    }

    public int getClientPort() {
        return this.getRequest().getRemotePort();
    }

    public String getHostDomain() {
        return this.getRequest().getServerName();
    }

    public String getMethod() {
        return this.getRequest().getMethod();
    }

    public Protocol getProtocol() {
        return Protocol.valueOf((String)this.getRequest().getScheme());
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public ReadableByteChannel getRequestEntityChannel(long size) {
        return null;
    }

    public InputStream getRequestEntityStream(long size) {
        try {
            return this.getRequest().getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public ReadableByteChannel getRequestHeadChannel() {
        return null;
    }

    public Series<Parameter> getRequestHeaders() {
        if (this.requestHeaders == null) {
            this.requestHeaders = new Form();
            Enumeration names = this.getRequest().getHeaderNames();
            while (names.hasMoreElements()) {
                String headerName = (String)names.nextElement();
                Enumeration values = this.getRequest().getHeaders(headerName);
                while (values.hasMoreElements()) {
                    String headerValue = (String)values.nextElement();
                    this.requestHeaders.add((Object)new Parameter(headerName, headerValue));
                }
            }
        }
        return this.requestHeaders;
    }

    public InputStream getRequestHeadStream() {
        return null;
    }

    public String getRequestUri() {
        String queryString = this.getRequest().getQueryString();
        if (queryString == null || queryString.equals("")) {
            return this.getRequest().getRequestURI();
        }
        return this.getRequest().getRequestURI() + '?' + queryString;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public WritableByteChannel getResponseEntityChannel() {
        return null;
    }

    public OutputStream getResponseEntityStream() {
        try {
            return this.getResponse().getOutputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getServerAddress() {
        return this.getRequest().getLocalAddr();
    }

    public int getServerPort() {
        return this.getRequest().getServerPort();
    }

    public String getSslCipherSuite() {
        return (String)this.getRequest().getAttribute("javax.servlet.request.cipher_suite");
    }

    public List<Certificate> getSslClientCertificates() {
        Certificate[] certificateArray = (Certificate[])this.getRequest().getAttribute("javax.servlet.request.X509Certificate");
        if (certificateArray != null) {
            return Arrays.asList(certificateArray);
        }
        return null;
    }

    public Integer getSslKeySize() {
        Integer keySize = (Integer)this.getRequest().getAttribute("javax.servlet.request.key_size");
        if (keySize == null) {
            keySize = super.getSslKeySize();
        }
        return keySize;
    }

    public Subject getSubject() {
        Subject result = null;
        if (this.getRequest().getUserPrincipal() != null) {
            CopyOnWriteArraySet<Principal> principals = new CopyOnWriteArraySet<Principal>();
            CopyOnWriteArraySet pubCredentials = new CopyOnWriteArraySet();
            CopyOnWriteArraySet privCredentials = new CopyOnWriteArraySet();
            principals.add(this.getRequest().getUserPrincipal());
            result = new Subject(false, principals, pubCredentials, privCredentials);
        }
        return result;
    }

    public String getVersion() {
        String result = null;
        int index = this.getRequest().getProtocol().indexOf(47);
        if (index != -1) {
            result = this.getRequest().getProtocol().substring(index + 1);
        }
        return result;
    }

    public boolean isConfidential() {
        return this.getRequest().isSecure();
    }

    public void sendResponse(Response response) throws IOException {
        if (Status.isError((int)this.getStatusCode()) && response.getEntity() == null) {
            try {
                for (Parameter header : this.getResponseHeaders()) {
                    if (header.getName().equals("Content-Length")) continue;
                    this.getResponse().addHeader(header.getName(), header.getValue());
                }
                this.getResponse().sendError(this.getStatusCode(), this.getReasonPhrase());
            }
            catch (IOException ioe) {
                this.getLogger().log(Level.WARNING, "Unable to set the response error status", ioe);
            }
        } else {
            this.getResponse().setStatus(this.getStatusCode());
            Parameter contentLengthHeader = null;
            for (Parameter header : this.getResponseHeaders()) {
                if (header.getName().equals("Content-Length")) {
                    contentLengthHeader = header;
                    continue;
                }
                this.getResponse().addHeader(header.getName(), header.getValue());
            }
            if (contentLengthHeader != null) {
                this.getResponse().addHeader(contentLengthHeader.getName(), contentLengthHeader.getValue());
            }
            super.sendResponse(response);
        }
    }
}

