/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.service;

import org.restlet.Context;
import org.restlet.data.ClientInfo;
import org.restlet.engine.application.TunnelFilter;
import org.restlet.routing.Filter;
import org.restlet.service.Service;

public class TunnelService
extends Service {
    private volatile String characterSetParameter;
    private volatile String encodingParameter;
    private volatile boolean extensionsTunnel;
    private volatile boolean headerTunnel;
    private volatile String languageParameter;
    private volatile String mediaTypeParameter;
    private volatile String methodHeader;
    private volatile String methodParameter;
    private volatile boolean methodTunnel;
    private volatile boolean preferencesTunnel;
    private volatile boolean queryTunnel;
    private volatile boolean userAgentTunnel;

    public TunnelService(boolean methodTunnel, boolean preferencesTunnel) {
        this(true, methodTunnel, preferencesTunnel);
    }

    public TunnelService(boolean enabled, boolean methodTunnel, boolean preferencesTunnel) {
        this(enabled, methodTunnel, preferencesTunnel, true, false);
    }

    public TunnelService(boolean enabled, boolean methodTunnel, boolean preferencesTunnel, boolean queryTunnel, boolean extensionsTunnel) {
        this(enabled, methodTunnel, preferencesTunnel, queryTunnel, extensionsTunnel, false);
    }

    public TunnelService(boolean enabled, boolean methodTunnel, boolean preferencesTunnel, boolean queryTunnel, boolean extensionsTunnel, boolean userAgentTunnel) {
        this(enabled, methodTunnel, preferencesTunnel, queryTunnel, extensionsTunnel, userAgentTunnel, true);
    }

    public TunnelService(boolean enabled, boolean methodTunnel, boolean preferencesTunnel, boolean queryTunnel, boolean extensionsTunnel, boolean userAgentTunnel, boolean methodHeaderTunnel) {
        super(enabled);
        this.extensionsTunnel = extensionsTunnel;
        this.methodTunnel = methodTunnel;
        this.preferencesTunnel = preferencesTunnel;
        this.queryTunnel = queryTunnel;
        this.userAgentTunnel = userAgentTunnel;
        this.headerTunnel = methodHeaderTunnel;
        this.characterSetParameter = "charset";
        this.encodingParameter = "encoding";
        this.languageParameter = "language";
        this.mediaTypeParameter = "media";
        this.methodParameter = "method";
        this.methodHeader = "X-HTTP-Method-Override";
    }

    public boolean allowClient(ClientInfo client) {
        return true;
    }

    public Filter createInboundFilter(Context context) {
        return new TunnelFilter(context);
    }

    public String getCharacterSetParameter() {
        return this.characterSetParameter;
    }

    public String getEncodingParameter() {
        return this.encodingParameter;
    }

    public String getLanguageParameter() {
        return this.languageParameter;
    }

    public String getMediaTypeParameter() {
        return this.mediaTypeParameter;
    }

    public String getMethodHeader() {
        return this.methodHeader;
    }

    public String getMethodParameter() {
        return this.methodParameter;
    }

    public boolean isExtensionsTunnel() {
        return this.extensionsTunnel;
    }

    public boolean isHeadersTunnel() {
        return this.headerTunnel;
    }

    public boolean isMethodTunnel() {
        return this.methodTunnel;
    }

    public boolean isPreferencesTunnel() {
        return this.preferencesTunnel;
    }

    public boolean isQueryTunnel() {
        return this.queryTunnel;
    }

    public boolean isUserAgentTunnel() {
        return this.userAgentTunnel;
    }

    public void setCharacterSetParameter(String parameterName) {
        this.characterSetParameter = parameterName;
    }

    public void setEncodingParameter(String parameterName) {
        this.encodingParameter = parameterName;
    }

    public void setExtensionsTunnel(boolean extensionTunnel) {
        this.extensionsTunnel = extensionTunnel;
    }

    public void setHeaderTunnel(boolean headerTunnel) {
        this.headerTunnel = headerTunnel;
    }

    public void setLanguageParameter(String parameterName) {
        this.languageParameter = parameterName;
    }

    public void setMediaTypeParameter(String parameterName) {
        this.mediaTypeParameter = parameterName;
    }

    public void setMethodHeader(String methodHeader) {
        this.methodHeader = methodHeader;
    }

    public void setMethodParameter(String parameterName) {
        this.methodParameter = parameterName;
    }

    public void setMethodTunnel(boolean methodTunnel) {
        this.methodTunnel = methodTunnel;
    }

    public void setPreferencesTunnel(boolean preferencesTunnel) {
        this.preferencesTunnel = preferencesTunnel;
    }

    public void setQueryTunnel(boolean queryTunnel) {
        this.queryTunnel = queryTunnel;
    }

    public void setUserAgentTunnel(boolean userAgentTunnel) {
        this.userAgentTunnel = userAgentTunnel;
    }
}

