/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.connector;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.http.connector.BaseHelper;
import org.restlet.engine.http.connector.ClientConnection;
import org.restlet.engine.http.connector.Connection;
import org.restlet.engine.http.connector.ConnectionState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseClientHelper
extends BaseHelper<Client> {
    private static final String CONNECTOR_LATCH = "org.restlet.engine.http.connector.latch";
    private volatile SocketFactory regularSocketFactory = null;
    private volatile SocketFactory secureSocketFactory = null;

    public BaseClientHelper(Client connector) {
        super(connector, true);
    }

    @Override
    protected Connection<Client> createConnection(BaseHelper<Client> helper, Socket socket, SocketChannel socketChannel) throws IOException {
        return new ClientConnection(helper, socket, socketChannel);
    }

    protected SocketFactory createSecureSocketFactory() throws IOException, GeneralSecurityException {
        String certAlgorithm = this.getCertAlgorithm();
        String keystorePath = this.getKeystorePath();
        String keystorePassword = this.getKeystorePassword();
        String keyPassword = this.getKeyPassword();
        String truststoreType = this.getTruststoreType();
        String truststorePath = this.getTruststorePath();
        String truststorePassword = this.getTruststorePassword();
        String secureRandomAlgorithm = this.getSecureRandomAlgorithm();
        String securityProvider = this.getSecurityProvider();
        FileInputStream keystoreInputStream = null;
        if (keystorePath != null && new File(keystorePath).exists()) {
            keystoreInputStream = new FileInputStream(keystorePath);
        }
        KeyStore keystore = null;
        if (keystoreInputStream != null) {
            try {
                keystore = KeyStore.getInstance(this.getKeystoreType());
                keystore.load(keystoreInputStream, keystorePassword == null ? null : keystorePassword.toCharArray());
            }
            catch (IOException ioe) {
                this.getLogger().log(Level.WARNING, "Unable to load the key store", ioe);
                keystore = null;
            }
        }
        KeyManager[] keyManagers = null;
        if (keystore != null && keyPassword != null) {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(certAlgorithm);
            keyManagerFactory.init(keystore, keyPassword.toCharArray());
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        FileInputStream truststoreInputStream = null;
        if (truststorePath != null && new File(truststorePath).exists()) {
            truststoreInputStream = new FileInputStream(truststorePath);
        }
        KeyStore truststore = null;
        if (truststoreType != null && truststoreInputStream != null) {
            try {
                truststore = KeyStore.getInstance(truststoreType);
                truststore.load(truststoreInputStream, truststorePassword == null ? null : truststorePassword.toCharArray());
            }
            catch (IOException ioe) {
                this.getLogger().log(Level.WARNING, "Unable to load the trust store", ioe);
                truststore = null;
            }
        }
        TrustManager[] trustManagers = null;
        if (truststore != null) {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(certAlgorithm);
            trustManagerFactory.init(truststore);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        SecureRandom secureRandom = secureRandomAlgorithm == null ? null : SecureRandom.getInstance(secureRandomAlgorithm);
        SSLContext context = securityProvider == null ? SSLContext.getInstance(this.getSslProtocol()) : SSLContext.getInstance(this.getSslProtocol(), securityProvider);
        context.init(keyManagers, trustManagers, secureRandom);
        return context.getSocketFactory();
    }

    protected Socket createSocket(boolean secure, InetSocketAddress socketAddress) throws UnknownHostException, IOException {
        return this.createSocket(secure, socketAddress.getHostName(), socketAddress.getPort());
    }

    protected Socket createSocket(boolean secure, String hostDomain, int hostPort) throws UnknownHostException, IOException {
        Socket result = null;
        SocketFactory factory = this.getSocketFactory(secure);
        if (factory != null) {
            result = factory.createSocket();
            InetSocketAddress address = new InetSocketAddress(hostDomain, hostPort);
            result.connect(address, this.getConnectTimeout());
            result.setTcpNoDelay(this.getTcpNoDelay());
        }
        return result;
    }

    protected SocketFactory createSocketFactory(boolean secure) {
        SocketFactory result;
        block4: {
            result = null;
            if (secure) {
                try {
                    return this.createSecureSocketFactory();
                }
                catch (IOException ex) {
                    this.getLogger().log(Level.SEVERE, "Could not create secure socket factory: " + ex.getMessage(), ex);
                    break block4;
                }
                catch (GeneralSecurityException ex) {
                    this.getLogger().log(Level.SEVERE, "Could not create secure socket factory: " + ex.getMessage(), ex);
                    break block4;
                }
            }
            result = SocketFactory.getDefault();
        }
        return result;
    }

    protected Connection<Client> getBestConnection(Request request) throws UnknownHostException, IOException {
        ClientConnection result = null;
        int hostConnectionCount = 0;
        int bestCount = 0;
        boolean foundConn = false;
        InetSocketAddress socketAddress = this.getSocketAddress(request);
        if (socketAddress == null) {
            this.getLogger().log(Level.WARNING, "Unable to create a socket address related to the request.");
        } else {
            Iterator iterator = this.getConnections().iterator();
            while (!foundConn && iterator.hasNext()) {
                ClientConnection currConn = (ClientConnection)iterator.next();
                if (!socketAddress.getAddress().equals(currConn.getSocket().getInetAddress()) || socketAddress.getPort() != currConn.getSocket().getPort()) continue;
                if (currConn.getState().equals((Object)ConnectionState.OPEN) && currConn.canEnqueue()) {
                    result = currConn;
                    foundConn = true;
                    continue;
                }
                int currCount = currConn.getOutboundMessages().size();
                if (bestCount > currCount) {
                    bestCount = currCount;
                    result = currConn;
                }
                ++hostConnectionCount;
            }
            if (!(foundConn || this.getMaxTotalConnections() != -1 && this.getConnections().size() >= this.getMaxTotalConnections() || this.getMaxConnectionsPerHost() != -1 && hostConnectionCount >= this.getMaxConnectionsPerHost())) {
                result = this.createConnection(this, this.createSocket(request.isConfidential(), socketAddress), (SocketChannel)null);
                result.open();
            }
        }
        return result;
    }

    public String getCertAlgorithm() {
        return this.getHelpedParameters().getFirstValue("certAlgorithm", "SunX509");
    }

    public int getConnectTimeout() {
        return ((Client)this.getHelped()).getConnectTimeout();
    }

    public String getKeyPassword() {
        return this.getHelpedParameters().getFirstValue("keyPassword", System.getProperty("javax.net.ssl.keyStorePassword"));
    }

    public String getKeystorePassword() {
        return this.getHelpedParameters().getFirstValue("keystorePassword", System.getProperty("javax.net.ssl.keyStorePassword"));
    }

    public String getKeystorePath() {
        return this.getHelpedParameters().getFirstValue("keystorePath", System.getProperty("user.home") + File.separator + ".keystore");
    }

    public String getKeystoreType() {
        return this.getHelpedParameters().getFirstValue("keystoreType", "JKS");
    }

    public String getProxyHost() {
        return this.getHelpedParameters().getFirstValue("proxyHost", System.getProperty("http.proxyHost"));
    }

    public int getProxyPort() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("proxyPort", System.getProperty("http.proxyPort")));
    }

    public SocketFactory getRegularSocketFactory() {
        return this.regularSocketFactory;
    }

    public String getSecureRandomAlgorithm() {
        return this.getHelpedParameters().getFirstValue("secureRandomAlgorithm", null);
    }

    public SocketFactory getSecureSocketFactory() {
        return this.secureSocketFactory;
    }

    public String getSecurityProvider() {
        return this.getHelpedParameters().getFirstValue("securityProvider", null);
    }

    protected InetSocketAddress getSocketAddress(Request request) throws UnknownHostException {
        InetSocketAddress result = null;
        String hostDomain = null;
        int hostPort = 0;
        String proxyDomain = this.getProxyHost();
        if (proxyDomain != null) {
            hostDomain = proxyDomain;
            try {
                hostPort = this.getProxyPort();
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log(Level.WARNING, "The proxy port must be a valid numeric value.", nfe);
                throw new UnknownHostException();
            }
        } else {
            Reference resourceRef = request.getResourceRef().isRelative() ? request.getResourceRef().getTargetRef() : request.getResourceRef();
            hostDomain = resourceRef.getHostDomain();
            hostPort = resourceRef.getHostPort();
            if (hostPort == -1) {
                hostPort = resourceRef.getSchemeProtocol() != null ? resourceRef.getSchemeProtocol().getDefaultPort() : this.getProtocols().get(0).getDefaultPort();
            }
        }
        if (hostDomain != null && (result = new InetSocketAddress(hostDomain, hostPort)) != null && result.getAddress() == null) {
            throw new UnknownHostException(hostDomain);
        }
        return result;
    }

    public SocketFactory getSocketFactory(boolean secure) {
        return secure ? this.getSecureSocketFactory() : this.getRegularSocketFactory();
    }

    public String getSslProtocol() {
        return this.getHelpedParameters().getFirstValue("sslProtocol", "TLS");
    }

    public boolean getTcpNoDelay() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("tcpNoDelay", "false"));
    }

    public String getTruststorePassword() {
        return this.getHelpedParameters().getFirstValue("truststorePassword", System.getProperty("javax.net.ssl.keyStorePassword"));
    }

    public String getTruststorePath() {
        return this.getHelpedParameters().getFirstValue("truststorePath", null);
    }

    public String getTruststoreType() {
        return this.getHelpedParameters().getFirstValue("truststoreType", System.getProperty("javax.net.ssl.trustStoreType"));
    }

    @Override
    public void handle(Request request, Response response) {
        try {
            if (request.getOnResponse() == null) {
                CountDownLatch latch = new CountDownLatch(1);
                request.getAttributes().put(CONNECTOR_LATCH, latch);
                this.getOutboundMessages().add(response);
                latch.await();
            } else {
                this.getOutboundMessages().add(response);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.INFO, "Error while handling a " + request.getProtocol().getName() + " client request", e);
            response.setStatus(Status.CONNECTOR_ERROR_INTERNAL, e);
        }
    }

    @Override
    public void handleInbound(Response response) {
        if (response != null) {
            if (response.getRequest().getOnResponse() != null) {
                response.getRequest().getOnResponse().handle(response.getRequest(), response);
            }
            if (!response.getStatus().isInformational()) {
                this.unblock(response);
            }
        }
    }

    @Override
    public void handleOutbound(Response response) {
        if (response != null && response.getRequest() != null) {
            try {
                Connection<Client> bestConn = this.getBestConnection(response.getRequest());
                if (bestConn != null) {
                    bestConn.getOutboundMessages().add(response);
                    this.getConnections().add(bestConn);
                    if (!response.getRequest().isExpectingResponse()) {
                        bestConn.writeMessages();
                        this.unblock(response);
                    }
                } else {
                    this.getLogger().log(Level.WARNING, "Unable to find a connection to send the request");
                }
            }
            catch (Throwable t) {
                this.getLogger().log(Level.FINE, "An error occured during the communication with the remote server.", t);
                response.setStatus(Status.CONNECTOR_ERROR_COMMUNICATION, t);
                this.unblock(response);
            }
        }
    }

    public void setRegularSocketFactory(SocketFactory regularSocketFactory) {
        this.regularSocketFactory = regularSocketFactory;
    }

    public void setSecureSocketFactory(SocketFactory secureSocketFactory) {
        this.secureSocketFactory = secureSocketFactory;
    }

    @Override
    public synchronized void start() throws Exception {
        this.setRegularSocketFactory(this.createSocketFactory(false));
        this.setSecureSocketFactory(this.createSocketFactory(true));
        super.start();
    }

    @Override
    public synchronized void stop() throws Exception {
        this.setRegularSocketFactory(null);
        this.setSecureSocketFactory(null);
        super.stop();
    }

    private void unblock(Response response) {
        CountDownLatch latch = (CountDownLatch)response.getRequest().getAttributes().get(CONNECTOR_LATCH);
        if (latch != null) {
            latch.countDown();
        }
    }
}

