/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.restlet.Connector;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.engine.connector.ConnectionController;
import org.restlet.engine.connector.ConnectionHelper;
import org.restlet.engine.connector.ConnectionState;
import org.restlet.engine.connector.Way;
import org.restlet.engine.io.ReadableSelectionChannel;
import org.restlet.engine.io.ReadableSocketChannel;
import org.restlet.engine.io.ReadableTraceChannel;
import org.restlet.engine.io.WritableSelectionChannel;
import org.restlet.engine.io.WritableSocketChannel;
import org.restlet.engine.io.WritableTraceChannel;
import org.restlet.engine.security.SslUtils;
import org.restlet.util.SelectionListener;
import org.restlet.util.SelectionRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connection<T extends Connector>
implements SelectionListener {
    private volatile ReadableSelectionChannel readableSelectionChannel;
    private volatile WritableSelectionChannel writableSelectionChannel;
    private final ConnectionHelper<T> helper;
    private final Way inboundWay;
    private volatile long lastActivity;
    private final Way outboundWay;
    private volatile boolean persistent;
    private volatile boolean pipelining;
    private volatile SocketChannel socketChannel;
    private volatile SocketAddress socketAddress;
    private volatile SelectionRegistration registration;
    private volatile ConnectionState state;

    public Connection(ConnectionHelper<T> helper, SocketChannel socketChannel, ConnectionController controller, SocketAddress socketAddress) throws IOException {
        this.helper = helper;
        this.inboundWay = helper.createInboundWay(this);
        this.outboundWay = helper.createOutboundWay(this);
        this.reuse(socketChannel, controller, socketAddress);
    }

    public void clear() {
        this.readableSelectionChannel = null;
        this.socketChannel = null;
        this.registration = null;
        this.state = null;
        this.writableSelectionChannel = null;
        this.inboundWay.clear();
        this.outboundWay.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean graceful) {
        if (graceful) {
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, "Closing connection to " + this.getSocketAddress() + " gracefully");
            }
            if (this.getRegistration() != null) {
                this.getRegistration().setCanceling(true);
            }
            this.setState(ConnectionState.CLOSING);
        } else {
            Socket socket;
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, "Closing connection to " + this.getSocketAddress() + " immediately");
            }
            try {
                socket = this.getSocket();
                if (socket != null && !socket.isClosed() && !(socket instanceof SSLSocket)) {
                    socket.shutdownInput();
                    socket.shutdownOutput();
                }
            }
            catch (IOException ex) {
                this.getLogger().log(Level.FINE, "Unable to properly shutdown socket", ex);
            }
            finally {
                this.setState(ConnectionState.CLOSED);
            }
            try {
                socket = this.getSocket();
                if (socket != null && !socket.isClosed()) {
                    socket.close();
                }
            }
            catch (IOException ex) {
                this.getLogger().log(Level.FINE, "Unable to properly close socket", ex);
            }
            finally {
                this.setState(ConnectionState.CLOSED);
            }
        }
    }

    public void commit(Response response) {
        this.getHelper().getOutboundMessages().add(response);
        this.getHelper().getController().wakeup();
    }

    public String getAddress() {
        return this.getSocket() == null ? null : (this.getSocket().getInetAddress() == null ? null : this.getSocket().getInetAddress().getHostAddress());
    }

    public ConnectionHelper<T> getHelper() {
        return this.helper;
    }

    public Way getInboundWay() {
        return this.inboundWay;
    }

    public Logger getLogger() {
        return this.getHelper().getLogger();
    }

    public Way getOutboundWay() {
        return this.outboundWay;
    }

    public int getPort() {
        return this.getSocket() == null ? -1 : this.getSocket().getPort();
    }

    protected ReadableSelectionChannel getReadableSelectionChannel() {
        return this.readableSelectionChannel;
    }

    protected SelectionRegistration getRegistration() {
        return this.registration;
    }

    public Socket getSocket() {
        return this.getSocketChannel() == null ? null : this.getSocketChannel().socket();
    }

    protected SocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public String getSslCipherSuite() {
        SSLSocket sslSocket;
        SSLSession sslSession;
        if (this.getSocket() instanceof SSLSocket && (sslSession = (sslSocket = (SSLSocket)this.getSocket()).getSession()) != null) {
            return sslSession.getCipherSuite();
        }
        return null;
    }

    public List<Certificate> getSslClientCertificates() {
        SSLSocket sslSocket;
        SSLSession sslSession;
        if (this.getSocket() instanceof SSLSocket && (sslSession = (sslSocket = (SSLSocket)this.getSocket()).getSession()) != null) {
            try {
                List<Certificate> clientCertificates = Arrays.asList(sslSession.getPeerCertificates());
                return clientCertificates;
            }
            catch (SSLPeerUnverifiedException e) {
                this.getHelper().getLogger().log(Level.FINE, "Can't get the client certificates.", e);
            }
        }
        return null;
    }

    public Integer getSslKeySize() {
        Integer keySize = null;
        String sslCipherSuite = this.getSslCipherSuite();
        if (sslCipherSuite != null) {
            keySize = SslUtils.extractKeySize(sslCipherSuite);
        }
        return keySize;
    }

    public ConnectionState getState() {
        return this.state;
    }

    protected WritableSelectionChannel getWritableSelectionChannel() {
        return this.writableSelectionChannel;
    }

    public boolean hasTimedOut() {
        return System.currentTimeMillis() - this.lastActivity >= (long)this.getHelper().getMaxIoIdleTimeMs();
    }

    public boolean isClientSide() {
        return this.getHelper().isClientSide();
    }

    public boolean isEmpty() {
        return this.getInboundWay().getMessages().isEmpty() && this.getOutboundWay().getMessages().isEmpty();
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public boolean isPipelining() {
        return this.pipelining;
    }

    public boolean isServerSide() {
        return this.getHelper().isServerSide();
    }

    public void onError(String message, Throwable throwable, Status status) {
        this.getLogger().log(Level.FINE, message, throwable);
        status = new Status(status, throwable, message);
        for (Response rsp : this.getInboundWay().getMessages()) {
            this.getInboundWay().getMessages().remove(rsp);
            this.getHelper().onError(status, rsp);
        }
        for (Response rsp : this.getOutboundWay().getMessages()) {
            this.getOutboundWay().getMessages().remove(rsp);
            this.getHelper().onError(status, rsp);
        }
        this.getHelper().onError(status, this.getInboundWay().getMessage());
        this.getHelper().onError(status, this.getOutboundWay().getMessage());
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSelected(SelectionRegistration registration) {
        block14: {
            Object trace;
            this.lastActivity = System.currentTimeMillis();
            if (this.getLogger().isLoggable(Level.FINER)) {
                trace = null;
                trace = this.isClientSide() ? "Client " : "Server ";
                this.getLogger().finer((String)trace + "connection (state | inbound | outbound): " + this.toString());
                this.getLogger().finer((String)trace + "NIO selection (interest | ready | cancelled): " + registration.toString());
            }
            try {
                if (registration == null || registration.isReadable()) {
                    trace = this.getInboundWay().getByteBuffer();
                    synchronized (trace) {
                        this.getInboundWay().getRegistration().onSelected(registration.getReadyOperations());
                        break block14;
                    }
                }
                if (registration.isWritable()) {
                    trace = this.getOutboundWay().getByteBuffer();
                    synchronized (trace) {
                        this.getOutboundWay().getRegistration().onSelected(registration.getReadyOperations());
                        break block14;
                    }
                }
                if (!registration.isConnectable()) break block14;
                try {
                    if (this.getSocketChannel().finishConnect()) {
                        this.open();
                        break block14;
                    }
                    this.onError("Unable to establish a connection to " + this.getSocketAddress(), null, Status.CONNECTOR_ERROR_CONNECTION);
                }
                catch (IOException e) {
                    this.onError("Unable to establish a connection to " + this.getSocketAddress(), e, Status.CONNECTOR_ERROR_CONNECTION);
                }
            }
            catch (Throwable t) {
                this.onError("Unexpected error detected. Closing the connection.", t, Status.CONNECTOR_ERROR_INTERNAL);
            }
        }
    }

    public void open() {
        this.setState(ConnectionState.OPEN);
        this.updateState();
    }

    public void reuse(SocketChannel socketChannel, ConnectionController controller, SocketAddress socketAddress) throws IOException {
        this.persistent = this.helper.isPersistingConnections();
        this.pipelining = this.helper.isPipeliningConnections();
        this.state = ConnectionState.OPENING;
        this.socketChannel = socketChannel;
        this.socketAddress = socketAddress;
        if (controller != null && socketChannel != null && socketAddress != null) {
            SelectionRegistration selectionRegistration = this.registration = controller == null ? null : controller.register(socketChannel, 0, this);
            if (this.helper.isTracing()) {
                this.readableSelectionChannel = new ReadableTraceChannel(new ReadableSocketChannel(socketChannel, this.registration));
                this.writableSelectionChannel = new WritableTraceChannel(new WritableSocketChannel(socketChannel, this.registration));
            } else {
                this.readableSelectionChannel = new ReadableSocketChannel(socketChannel, this.registration);
                this.writableSelectionChannel = new WritableSocketChannel(socketChannel, this.registration);
            }
        }
        this.lastActivity = System.currentTimeMillis();
        this.inboundWay.reuse();
        this.outboundWay.reuse();
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setPipelining(boolean pipelining) {
        this.pipelining = pipelining;
    }

    protected void setRegistration(SelectionRegistration registration) {
        this.registration = registration;
    }

    public void setState(ConnectionState state) {
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().finest("Connection state (old | new) : " + (Object)((Object)this.state) + " | " + (Object)((Object)state));
        }
        this.state = state;
    }

    public String toString() {
        return (Object)((Object)this.getState()) + " | " + this.getInboundWay() + " | " + this.getOutboundWay();
    }

    public boolean updateState() {
        boolean result = false;
        if (this.getState() != ConnectionState.CLOSING && this.getState() != ConnectionState.CLOSED) {
            this.getInboundWay().updateState();
            this.getOutboundWay().updateState();
            result = this.getRegistration().setInterestOperations(this.getInboundWay().getRegistration().getInterestOperations() | this.getOutboundWay().getRegistration().getInterestOperations());
        }
        return result;
    }
}

