/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.security.Principal;
import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.data.Protocol;
import org.restlet.engine.header.Header;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.ReadableRepresentation;
import org.restlet.representation.Representation;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Call {
    private volatile String clientAddress = null;
    private volatile int clientPort = -1;
    private volatile boolean confidential = false;
    private volatile String hostDomain = null;
    private volatile int hostPort = -1;
    private volatile String method = null;
    private volatile Protocol protocol = null;
    private volatile String reasonPhrase = "";
    private final Series<Header> requestHeaders = new Series<Header>(Header.class);
    private volatile String requestUri = null;
    private final Series<Header> responseHeaders = new Series<Header>(Header.class);
    private volatile String serverAddress = null;
    private volatile int serverPort = -1;
    private volatile int statusCode = 200;
    private volatile Principal userPrincipal = null;
    private volatile String version = null;

    public static boolean isBroken(Throwable exception) {
        boolean result = false;
        if (exception.getMessage() != null) {
            result = exception.getMessage().indexOf("Broken pipe") != -1 || exception.getMessage().equals("An existing connection must have been closed by the remote party.") || exception.getMessage().equals("An open connection has been abandonned by your network stack.");
        }
        return result;
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public int getClientPort() {
        return this.clientPort;
    }

    public String getHostDomain() {
        return this.hostDomain;
    }

    public int getHostPort() {
        return this.hostPort;
    }

    public Logger getLogger() {
        return Context.getCurrentLogger();
    }

    public String getMethod() {
        return this.method;
    }

    public Protocol getProtocol() {
        if (this.protocol == null) {
            this.protocol = this.isConfidential() ? Protocol.HTTPS : Protocol.HTTP;
        }
        return this.protocol;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    protected Representation getRepresentation(InputStream stream) {
        return new InputRepresentation(stream, null);
    }

    protected Representation getRepresentation(ReadableByteChannel channel) {
        return new ReadableRepresentation(channel, null);
    }

    public Series<Header> getRequestHeaders() {
        return this.requestHeaders;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public Series<Header> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public int getStatusCode() throws IOException {
        return this.statusCode;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public String getVersion() {
        return this.version;
    }

    protected abstract boolean isClientKeepAlive();

    public boolean isConfidential() {
        return this.confidential;
    }

    public boolean isConnectionBroken(Throwable exception) {
        return Call.isBroken(exception);
    }

    protected boolean isKeepAlive() {
        return this.isClientKeepAlive() && this.isServerKeepAlive();
    }

    protected boolean isRequestChunked() {
        return HeaderUtils.isChunkedEncoding(this.getRequestHeaders());
    }

    protected boolean isResponseChunked() {
        return HeaderUtils.isChunkedEncoding(this.getResponseHeaders());
    }

    protected abstract boolean isServerKeepAlive();

    protected void setClientAddress(String clientAddress) {
        this.clientAddress = clientAddress;
    }

    protected void setClientPort(int clientPort) {
        this.clientPort = clientPort;
    }

    protected void setConfidential(boolean confidential) {
        this.confidential = confidential;
    }

    public void setHostDomain(String hostDomain) {
        this.hostDomain = hostDomain;
    }

    public void setHostPort(int hostPort) {
        this.hostPort = hostPort;
    }

    protected void setMethod(String method) {
        this.method = method;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
    }

    protected void setRequestUri(String requestUri) {
        if (requestUri == null || requestUri.equals("")) {
            requestUri = "/";
        }
        this.requestUri = requestUri;
    }

    public void setServerAddress(String responseAddress) {
        this.serverAddress = responseAddress;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setStatusCode(int code) {
        this.statusCode = code;
    }

    public void setUserPrincipal(Principal principal) {
        this.userPrincipal = principal;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

