/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import java.security.Principal;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Role
implements Principal {
    public static final Role ALL = new Role("*", "Role that covers all existing roles."){

        public void setDescription(String description) {
            throw new IllegalStateException("Unmodifiable role");
        }

        public void setName(String name) {
            throw new IllegalStateException("Unmodifiable role");
        }
    };
    private final List<Role> childRoles;
    private volatile String description;
    private volatile String name;

    public Role() {
        this(null, null);
    }

    public Role(String name, String description) {
        this.name = name;
        this.description = description;
        this.childRoles = new CopyOnWriteArrayList<Role>();
    }

    @Override
    public boolean equals(Object target) {
        boolean result = false;
        if (this.name == null) {
            return target == null;
        }
        if (target instanceof Role) {
            Role r = (Role)target;
            boolean bl = result = this.name.equals(r.getName()) && this.getChildRoles().size() == r.getChildRoles().size();
            if (result && !this.getChildRoles().isEmpty()) {
                for (int i = 0; result && i < this.getChildRoles().size(); ++i) {
                    result = this.getChildRoles().get(i).equals(r.getChildRoles().get(i));
                }
            }
        }
        return result;
    }

    public List<Role> getChildRoles() {
        return this.childRoles;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int hashCode() {
        int result;
        if (this.name == null) {
            result = super.hashCode();
        } else if (this.getChildRoles().isEmpty()) {
            result = this.name.hashCode();
        } else {
            StringBuilder sb = new StringBuilder(this.name).append("(");
            for (Role role : this.getChildRoles()) {
                sb.append(role.hashCode()).append("-");
            }
            sb.append(")");
            result = sb.toString().hashCode();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildRoles(List<Role> childRoles) {
        List<Role> list = this.getChildRoles();
        synchronized (list) {
            if (childRoles != this.getChildRoles()) {
                this.getChildRoles().clear();
                if (childRoles != null) {
                    this.getChildRoles().addAll(childRoles);
                }
            }
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

