/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.header;

import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import org.restlet.data.Metadata;
import org.restlet.data.Parameter;
import org.restlet.data.Preference;
import org.restlet.engine.header.HeaderWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceWriter
extends HeaderWriter<Preference<?>> {
    public static boolean isValidQuality(float quality) {
        return quality >= 0.0f && quality <= 1.0f;
    }

    public static String write(List prefs) {
        return ((HeaderWriter)new PreferenceWriter()).append(prefs).toString();
    }

    public PreferenceWriter append(Preference<?> pref) {
        this.append(((Metadata)pref.getMetadata()).getName());
        if (pref.getQuality() < 1.0f) {
            this.append(";q=");
            this.appendQuality(pref.getQuality());
        }
        if (pref.getParameters() != null) {
            for (Parameter param : pref.getParameters()) {
                if (param.getName() == null) continue;
                ((HeaderWriter)this.append(';')).append(param.getName());
                if (param.getValue() == null || param.getValue().length() <= 0) continue;
                ((HeaderWriter)this.append('=')).append(param.getValue());
            }
        }
        return this;
    }

    public PreferenceWriter appendQuality(float quality) {
        if (!PreferenceWriter.isValidQuality(quality)) {
            throw new IllegalArgumentException("Invalid quality value detected. Value must be between 0 and 1.");
        }
        NumberFormat formatter = NumberFormat.getNumberInstance(Locale.US);
        formatter.setMaximumFractionDigits(2);
        this.append(formatter.format(quality));
        return this;
    }
}

