/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine;

import java.util.logging.Level;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Status;
import org.restlet.engine.RestletHelper;
import org.restlet.routing.Filter;

public abstract class CompositeHelper<T extends Restlet>
extends RestletHelper<T> {
    private volatile Filter firstInboundFilter = null;
    private volatile Filter firstOutboundFilter = null;
    private volatile Restlet inboundNext = null;
    private volatile Filter lastInboundFilter = null;
    private volatile Filter lastOutboundFilter = null;
    private volatile Restlet outboundNext = null;

    public CompositeHelper(T helped) {
        super(helped);
    }

    protected synchronized void addInboundFilter(Filter filter) {
        Restlet next = this.getInboundNext();
        if (this.getFirstInboundFilter() == null) {
            this.setFirstInboundFilter(filter);
        } else if (this.getLastInboundFilter() != null) {
            this.getLastInboundFilter().setNext(filter);
        }
        this.setLastInboundFilter(filter);
        this.setInboundNext(next);
    }

    protected synchronized void addOutboundFilter(Filter filter) {
        Restlet next = this.getOutboundNext();
        if (this.getFirstOutboundFilter() == null) {
            this.setFirstOutboundFilter(filter);
        } else if (this.getLastOutboundFilter() != null) {
            this.getLastOutboundFilter().setNext(filter);
        }
        this.setLastOutboundFilter(filter);
        this.setOutboundNext(next);
    }

    public void clear() {
        this.setFirstInboundFilter(null);
        this.setFirstOutboundFilter(null);
        this.setInboundNext(null);
        this.setLastInboundFilter(null);
        this.setLastOutboundFilter(null);
        this.setOutboundNext(null);
    }

    public Filter getFirstInboundFilter() {
        return this.firstInboundFilter;
    }

    public Filter getFirstOutboundFilter() {
        return this.firstOutboundFilter;
    }

    protected synchronized Restlet getInboundNext() {
        Restlet result = null;
        result = this.getLastInboundFilter() != null ? this.getLastInboundFilter().getNext() : this.inboundNext;
        return result;
    }

    protected Filter getLastInboundFilter() {
        return this.lastInboundFilter;
    }

    protected Filter getLastOutboundFilter() {
        return this.lastOutboundFilter;
    }

    public synchronized Restlet getOutboundNext() {
        Restlet result = null;
        result = this.getLastOutboundFilter() != null ? this.getLastOutboundFilter().getNext() : this.outboundNext;
        return result;
    }

    @Override
    public void handle(Request request, Response response) {
        super.handle(request, response);
        if (this.getFirstInboundFilter() != null) {
            this.getFirstInboundFilter().handle(request, response);
        } else {
            response.setStatus(Status.SERVER_ERROR_INTERNAL);
            ((Restlet)this.getHelped()).getLogger().log(Level.SEVERE, "The " + this.getHelped().getClass().getName() + " class has no Restlet defined to process calls. Maybe it wasn't properly started.");
        }
    }

    protected void setFirstInboundFilter(Filter firstInboundFilter) {
        this.firstInboundFilter = firstInboundFilter;
    }

    protected void setFirstOutboundFilter(Filter firstOutboundFilter) {
        this.firstOutboundFilter = firstOutboundFilter;
    }

    protected synchronized void setInboundNext(Restlet next) {
        if (this.getLastInboundFilter() != null) {
            this.getLastInboundFilter().setNext(next);
        }
        this.inboundNext = next;
    }

    protected void setLastInboundFilter(Filter last) {
        this.lastInboundFilter = last;
    }

    protected void setLastOutboundFilter(Filter last) {
        this.lastOutboundFilter = last;
    }

    protected synchronized void setOutboundNext(Restlet next) {
        if (this.getLastOutboundFilter() != null) {
            this.getLastOutboundFilter().setNext(next);
        }
        this.outboundNext = next;
    }
}

