/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.crypto.internal;

import java.util.Date;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.restlet.Request;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.engine.http.header.ChallengeWriter;
import org.restlet.engine.io.BioUtils;
import org.restlet.engine.security.AuthenticatorHelper;
import org.restlet.engine.util.Base64;
import org.restlet.engine.util.DateUtils;
import org.restlet.engine.util.SystemUtils;
import org.restlet.ext.crypto.DigestUtils;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpAwsS3Helper
extends AuthenticatorHelper {
    private static String getCanonicalizedAmzHeaders(Series<Parameter> requestHeaders) {
        TreeMap<String, String> amzHeaders = new TreeMap<String, String>();
        for (Parameter param : requestHeaders) {
            String headerName = param.getName().toLowerCase();
            if (!headerName.startsWith("x-amz-") || amzHeaders.containsKey(headerName)) continue;
            amzHeaders.put(headerName, requestHeaders.getValues(headerName));
        }
        StringBuilder sb = new StringBuilder();
        for (String key : amzHeaders.keySet()) {
            sb.append(key).append(':').append((String)amzHeaders.get(key)).append("\n");
        }
        return sb.toString();
    }

    private static String getCanonicalizedResourceName(Reference reference) {
        int queryIdx;
        String hostName = reference.getHostDomain();
        String path = reference.getPath();
        Pattern hostNamePattern = Pattern.compile("s3[a-z0-1\\-]*.amazonaws.com");
        StringBuilder sb = new StringBuilder();
        if (hostName != null) {
            if (hostName.contains(":")) {
                hostName = hostName.substring(0, hostName.indexOf(":"));
            }
            Matcher hostNameMatcher = hostNamePattern.matcher(hostName);
            if (hostName.endsWith(".s3.amazonaws.com")) {
                String bucketName = hostName.substring(0, hostName.length() - 17);
                sb.append("/" + bucketName);
            } else if (!hostNameMatcher.matches()) {
                sb.append("/" + hostName);
            }
        }
        if ((queryIdx = path.indexOf("?")) >= 0) {
            sb.append(path.substring(0, queryIdx));
        } else {
            sb.append(path.substring(0, path.length()));
        }
        if (queryIdx >= 0) {
            String query = path.substring(queryIdx - 1, path.length());
            if (query.contains("?acl")) {
                sb.append("?acl");
            } else if (query.contains("?location")) {
                sb.append("?location");
            } else if (query.contains("?logging")) {
                sb.append("?logging");
            } else if (query.contains("?torrent")) {
                sb.append("?torrent");
            }
        }
        return sb.toString();
    }

    public HttpAwsS3Helper() {
        super(ChallengeScheme.HTTP_AWS_S3, true, false);
    }

    public void formatRawResponse(ChallengeWriter cw, ChallengeResponse challenge, Request request, Series<Parameter> httpHeaders) {
        String contentType;
        String contentMd5;
        String methodName = request.getMethod().getName();
        String date = "";
        if (httpHeaders.getFirstValue("X-Amz-Date", true) == null && (date = httpHeaders.getFirstValue("Date", true)) == null) {
            date = DateUtils.format((Date)new Date(), (String)((String)DateUtils.FORMAT_RFC_1123.get(0)));
            httpHeaders.add("Date", date);
        }
        if ((contentMd5 = httpHeaders.getFirstValue("Content-MD5", true)) == null) {
            contentMd5 = "";
        }
        if ((contentType = httpHeaders.getFirstValue("Content-Type", true)) == null) {
            boolean applyPatch = false;
            String jvmVendor = System.getProperty("java.vm.vendor");
            if (jvmVendor != null && jvmVendor.toLowerCase().startsWith("sun")) {
                int majorVersionNumber = SystemUtils.getJavaMajorVersion();
                int minorVersionNumber = SystemUtils.getJavaMinorVersion();
                if (majorVersionNumber == 1) {
                    if (minorVersionNumber < 5) {
                        applyPatch = true;
                    } else if (minorVersionNumber == 5) {
                        applyPatch = SystemUtils.getJavaUpdateVersion() < 10;
                    }
                }
            }
            contentType = applyPatch && !request.getMethod().equals((Object)Method.PUT) ? "application/x-www-form-urlencoded" : "";
        }
        String canonicalizedAmzHeaders = HttpAwsS3Helper.getCanonicalizedAmzHeaders(httpHeaders);
        String canonicalizedResource = HttpAwsS3Helper.getCanonicalizedResourceName(request.getResourceRef());
        StringBuilder rest = new StringBuilder();
        rest.append(methodName).append('\n').append(contentMd5).append('\n').append(contentType).append('\n').append(date).append('\n').append(canonicalizedAmzHeaders).append(canonicalizedResource);
        cw.append((CharSequence)challenge.getIdentifier()).append(':').append((CharSequence)Base64.encode((byte[])DigestUtils.toHMac(rest.toString(), BioUtils.toByteArray((char[])challenge.getSecret())), (boolean)false));
    }
}

