/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.crypto.internal;

import java.io.IOException;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.engine.http.header.ChallengeWriter;
import org.restlet.engine.http.header.HeaderReader;
import org.restlet.engine.http.header.HeaderUtils;
import org.restlet.engine.security.AuthenticatorHelper;
import org.restlet.engine.security.AuthenticatorUtils;
import org.restlet.engine.util.Base64;
import org.restlet.ext.crypto.DigestUtils;
import org.restlet.ext.crypto.internal.CryptoUtils;
import org.restlet.security.Guard;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpDigestHelper
extends AuthenticatorHelper {
    @Deprecated
    private static String getHashedSecret(String identifier, Guard guard) {
        char[] secret = (char[])guard.getSecretResolver().resolve(identifier);
        if (secret != null) {
            return DigestUtils.toHttpDigest(identifier, secret, guard.getRealm());
        }
        return null;
    }

    public static boolean isNonceValid(String nonce, String secretKey, long lifespan) throws Exception {
        try {
            String decodedNonce = new String(Base64.decode((String)nonce));
            long nonceTimeMS = Long.parseLong(decodedNonce.substring(0, decodedNonce.indexOf(58)));
            if (decodedNonce.equals(nonceTimeMS + ":" + DigestUtils.toMd5(nonceTimeMS + ":" + secretKey))) {
                return lifespan > System.currentTimeMillis() - nonceTimeMS;
            }
        }
        catch (Exception e) {
            throw new Exception("Error detected parsing nonce: " + e);
        }
        throw new Exception("The nonce does not match secretKey");
    }

    public HttpDigestHelper() {
        super(ChallengeScheme.HTTP_DIGEST, true, true);
    }

    @Deprecated
    public int authenticate(ChallengeResponse cr, Request request, Guard guard) {
        Series parameters = cr.getParameters();
        String username = cr.getIdentifier();
        String response = new String(cr.getSecret());
        String nonce = parameters.getFirstValue("nonce");
        String uri = parameters.getFirstValue("uri");
        String qop = parameters.getFirstValue("qop");
        String nc = parameters.getFirstValue("nc");
        String cnonce = parameters.getFirstValue("cnonce");
        try {
            if (!HttpDigestHelper.isNonceValid(nonce, guard.getServerKey(), guard.getNonceLifespan())) {
                return 2;
            }
        }
        catch (Exception ce) {
            return -1;
        }
        if (!AuthenticatorUtils.anyNull((Object[])new Object[]{username, nonce, response, uri})) {
            String a1;
            Reference resourceRef = request.getResourceRef();
            String requestUri = resourceRef.getPath();
            if (resourceRef.getQuery() != null && uri.indexOf(63) > -1) {
                requestUri = requestUri + "?" + resourceRef.getQuery();
            }
            if (uri.equals(requestUri) && (a1 = HttpDigestHelper.getHashedSecret(username, guard)) != null) {
                String a2 = DigestUtils.toMd5(request.getMethod() + ":" + requestUri);
                StringBuffer expectedResponse = new StringBuffer(a1).append(':').append(nonce);
                if (!AuthenticatorUtils.anyNull((Object[])new Object[]{qop, cnonce, nc})) {
                    expectedResponse.append(':').append(nc).append(':').append(cnonce).append(':').append(qop);
                }
                expectedResponse.append(':').append(a2);
                if (response.equals(DigestUtils.toMd5(expectedResponse.toString()))) {
                    return 1;
                }
            }
            return -1;
        }
        return 0;
    }

    @Deprecated
    public void challenge(Response response, boolean stale, Guard guard) {
        super.challenge(response, stale, guard);
        ChallengeRequest mainChallengeRequest = null;
        for (ChallengeRequest challengeRequest : response.getChallengeRequests()) {
            if (!challengeRequest.getScheme().equals((Object)guard.getScheme())) continue;
            mainChallengeRequest = challengeRequest;
            break;
        }
        if (mainChallengeRequest != null) {
            mainChallengeRequest.setDomainUris(guard.getDomainUris());
            mainChallengeRequest.setStale(stale);
            mainChallengeRequest.setServerNonce(CryptoUtils.makeNonce(guard.getServerKey()));
        }
    }

    public void formatRawRequest(ChallengeWriter cw, ChallengeRequest challenge, Response response, Series<Parameter> httpHeaders) throws IOException {
        int i;
        if (challenge.getRealm() != null) {
            cw.appendQuotedChallengeParameter("realm", challenge.getRealm());
        }
        if (!challenge.getDomainRefs().isEmpty()) {
            cw.append((CharSequence)", domain=\"");
            for (i = 0; i < challenge.getDomainRefs().size(); ++i) {
                if (i > 0) {
                    cw.append(' ');
                }
                cw.append((CharSequence)((Reference)challenge.getDomainRefs().get(i)).toString());
            }
            cw.append('\"');
        }
        if (challenge.getServerNonce() != null) {
            cw.appendQuotedChallengeParameter("nonce", challenge.getServerNonce());
        }
        if (challenge.getOpaque() != null) {
            cw.appendQuotedChallengeParameter("opaque", challenge.getOpaque());
        }
        if (challenge.isStale()) {
            cw.appendChallengeParameter("stale", "true");
        }
        if (challenge.getDigestAlgorithm() != null) {
            cw.appendChallengeParameter("algorithm", challenge.getDigestAlgorithm());
        }
        if (!challenge.getQualityOptions().isEmpty()) {
            cw.append((CharSequence)", qop=\"");
            for (i = 0; i < challenge.getQualityOptions().size(); ++i) {
                if (i > 0) {
                    cw.append(',');
                }
                cw.appendToken(((String)challenge.getQualityOptions().get(i)).toString());
            }
            cw.append('\"');
        }
        for (Parameter param : challenge.getParameters()) {
            if (HeaderUtils.isToken((CharSequence)param.getValue())) {
                cw.appendChallengeParameter(param);
                continue;
            }
            cw.appendQuotedChallengeParameter(param);
        }
    }

    public void formatRawResponse(ChallengeWriter cw, ChallengeResponse challenge, Request request, Series<Parameter> httpHeaders) {
        char[] secret;
        if (challenge.getIdentifier() != null) {
            cw.appendQuotedChallengeParameter("username", challenge.getIdentifier());
        }
        if (challenge.getRealm() != null) {
            cw.appendQuotedChallengeParameter("realm", challenge.getRealm());
        }
        if (challenge.getServerNonce() != null) {
            cw.appendQuotedChallengeParameter("nonce", challenge.getServerNonce());
        }
        if (challenge.getDigestRef() != null) {
            challenge.setDigestRef(new Reference(request.getResourceRef().getPath()));
            cw.appendQuotedChallengeParameter("uri", challenge.getDigestRef().toString());
        }
        if ((secret = this.formatSecret(challenge, request, null, challenge.getIdentifier(), challenge.getSecret(), "NONE")) != null) {
            cw.appendQuotedChallengeParameter("response", new String(secret));
        }
        if (challenge.getDigestAlgorithm() != null && !"MD5".equals(challenge.getDigestAlgorithm())) {
            cw.appendChallengeParameter("algorithm", challenge.getDigestAlgorithm());
        }
        if (challenge.getClientNonce() != null) {
            cw.appendQuotedChallengeParameter("cnonce", challenge.getClientNonce());
        }
        if (challenge.getOpaque() != null) {
            cw.appendQuotedChallengeParameter("opaque", challenge.getOpaque());
        }
        if (challenge.getQuality() != null) {
            cw.appendChallengeParameter("qop", challenge.getQuality());
        }
        if (challenge.getQuality() != null && challenge.getServerNounceCount() > 0) {
            cw.appendChallengeParameter("nc", challenge.getServerNounceCountAsHex());
        }
        for (Parameter param : challenge.getParameters()) {
            if (HeaderUtils.isToken((CharSequence)param.getValue())) {
                cw.appendChallengeParameter(param);
                continue;
            }
            cw.appendQuotedChallengeParameter(param);
        }
    }

    public char[] formatSecret(ChallengeResponse challengeResponse, Request request, Response response, String identifier, char[] baseSecret, String baseSecretAlgorithm) {
        String a1 = null;
        if (!"HTTP-DIGEST-A1".equals(baseSecretAlgorithm)) {
            if (!AuthenticatorUtils.anyNull((Object[])new Object[]{challengeResponse.getIdentifier(), baseSecret, challengeResponse.getRealm()})) {
                a1 = DigestUtils.toHttpDigest(identifier, baseSecret, challengeResponse.getRealm());
            }
        } else {
            a1 = new String(baseSecret);
        }
        if (a1 != null && !AuthenticatorUtils.anyNull((Object[])new Object[]{request.getMethod(), challengeResponse.getDigestRef()})) {
            String a2 = DigestUtils.toMd5(request.getMethod().toString() + ":" + challengeResponse.getDigestRef().toString());
            StringBuilder sb = new StringBuilder().append(a1).append(':').append(challengeResponse.getServerNonce());
            if (!AuthenticatorUtils.anyNull((Object[])new Object[]{challengeResponse.getQuality(), challengeResponse.getClientNonce(), challengeResponse.getServerNounceCount()})) {
                sb.append(':').append(AuthenticatorUtils.formatNonceCount((int)challengeResponse.getServerNounceCount())).append(':').append(challengeResponse.getClientNonce()).append(':').append(challengeResponse.getQuality());
            }
            sb.append(':').append(a2);
            return DigestUtils.toMd5(sb.toString()).toCharArray();
        }
        return null;
    }

    public void parseRequest(ChallengeRequest challenge, Response response, Series<Parameter> httpHeaders) {
        if (challenge.getRawValue() != null) {
            HeaderReader hr = new HeaderReader(challenge.getRawValue());
            try {
                Parameter param = hr.readParameter();
                while (param != null) {
                    try {
                        if ("realm".equals(param.getName())) {
                            challenge.setRealm(param.getValue());
                        } else if ("domain".equals(param.getName())) {
                            challenge.getDomainRefs().add(new Reference(param.getValue()));
                        } else if ("nonce".equals(param.getName())) {
                            challenge.setServerNonce(param.getValue());
                        } else if ("opaque".equals(param.getName())) {
                            challenge.setOpaque(param.getValue());
                        } else if ("stale".equals(param.getName())) {
                            challenge.setStale(Boolean.valueOf(param.getValue()).booleanValue());
                        } else if ("algorithm".equals(param.getName())) {
                            challenge.setDigestAlgorithm(param.getValue());
                        } else if (!"qop".equals(param.getName())) {
                            challenge.getParameters().add((Object)param);
                        }
                        if (hr.skipValueSeparator()) {
                            param = hr.readParameter();
                            continue;
                        }
                        param = null;
                    }
                    catch (Exception e) {
                        Context.getCurrentLogger().log(Level.WARNING, "Unable to parse the challenge request header parameter", e);
                    }
                }
            }
            catch (Exception e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to parse the challenge request header parameter", e);
            }
        }
    }

    public void parseResponse(ChallengeResponse challenge, Request request, Series<Parameter> httpHeaders) {
        if (challenge.getCredentials() != null) {
            HeaderReader hr = new HeaderReader(challenge.getCredentials());
            try {
                Parameter param = hr.readParameter();
                while (param != null) {
                    try {
                        if ("username".equals(param.getName())) {
                            challenge.setIdentifier(param.getValue());
                        } else if ("realm".equals(param.getName())) {
                            challenge.setRealm(param.getValue());
                        } else if ("nonce".equals(param.getName())) {
                            challenge.setServerNonce(param.getValue());
                        } else if ("uri".equals(param.getName())) {
                            challenge.setDigestRef(new Reference(param.getValue()));
                        } else if ("response".equals(param.getName())) {
                            challenge.setSecret(param.getValue());
                        } else if ("algorithm".equals(param.getName())) {
                            challenge.setDigestAlgorithm(param.getValue());
                        } else if ("cnonce".equals(param.getName())) {
                            challenge.setClientNonce(param.getValue());
                        } else if ("opaque".equals(param.getName())) {
                            challenge.setOpaque(param.getValue());
                        } else if ("qop".equals(param.getName())) {
                            challenge.setQuality(param.getValue());
                        } else if ("nc".equals(param.getName())) {
                            challenge.setServerNounceCount(Integer.valueOf(param.getValue(), 16).intValue());
                        } else {
                            challenge.getParameters().add((Object)param);
                        }
                    }
                    catch (Throwable e) {
                        Context.getCurrentLogger().log(Level.WARNING, "Unable to parse the challenge request header parameter", e);
                    }
                    if (hr.skipValueSeparator()) {
                        param = hr.readParameter();
                        continue;
                    }
                    param = null;
                }
            }
            catch (Exception e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to parse the challenge request header parameter", e);
            }
        }
    }
}

