/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.crypto.internal;

import java.util.Date;
import java.util.TreeMap;
import org.restlet.Request;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.engine.header.ChallengeWriter;
import org.restlet.engine.header.Header;
import org.restlet.engine.security.AuthenticatorHelper;
import org.restlet.engine.util.Base64;
import org.restlet.engine.util.DateUtils;
import org.restlet.engine.util.SystemUtils;
import org.restlet.ext.crypto.DigestUtils;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpAzureSharedKeyHelper
extends AuthenticatorHelper {
    private static String getCanonicalizedAzureHeaders(Series<Header> requestHeaders) {
        TreeMap<String, String> azureHeaders = new TreeMap<String, String>();
        for (Header header : requestHeaders) {
            String headerName = header.getName().toLowerCase();
            if (!headerName.startsWith("x-ms-") || azureHeaders.containsKey(headerName)) continue;
            azureHeaders.put(headerName, requestHeaders.getValues(headerName));
        }
        StringBuilder sb = new StringBuilder();
        for (String key : azureHeaders.keySet()) {
            sb.append(key).append(':').append((String)azureHeaders.get(key)).append("\n");
        }
        return sb.toString();
    }

    private static String getCanonicalizedResourceName(Reference resourceRef) {
        Form form = resourceRef.getQueryAsForm();
        Parameter param = (Parameter)form.getFirst("comp", true);
        if (param != null) {
            StringBuilder sb = new StringBuilder(resourceRef.getPath());
            return sb.append("?").append("comp=").append(param.getValue()).toString();
        }
        return resourceRef.getPath();
    }

    public HttpAzureSharedKeyHelper() {
        super(ChallengeScheme.HTTP_AZURE_SHAREDKEY, true, false);
    }

    public void formatResponse(ChallengeWriter cw, ChallengeResponse challenge, Request request, Series<Header> httpHeaders) {
        String contentType;
        String contentMd5;
        String methodName = request.getMethod().getName();
        String date = "";
        if (httpHeaders.getFirstValue("x-ms-date", true) == null && (date = httpHeaders.getFirstValue("Date", true)) == null) {
            date = DateUtils.format((Date)new Date(), (String)((String)DateUtils.FORMAT_RFC_1123.get(0)));
            httpHeaders.add("Date", date);
        }
        if ((contentMd5 = httpHeaders.getFirstValue("Content-MD5", true)) == null) {
            contentMd5 = "";
        }
        if ((contentType = httpHeaders.getFirstValue("Content-Type", true)) == null) {
            boolean applyPatch = false;
            String jvmVendor = System.getProperty("java.vm.vendor");
            if (jvmVendor != null && jvmVendor.toLowerCase().startsWith("sun")) {
                int majorVersionNumber = SystemUtils.getJavaMajorVersion();
                int minorVersionNumber = SystemUtils.getJavaMinorVersion();
                if (majorVersionNumber == 1) {
                    if (minorVersionNumber < 5) {
                        applyPatch = true;
                    } else if (minorVersionNumber == 5) {
                        applyPatch = SystemUtils.getJavaUpdateVersion() < 10;
                    }
                }
            }
            contentType = applyPatch && !request.getMethod().equals((Object)Method.PUT) ? "application/x-www-form-urlencoded" : "";
        }
        String canonicalizedAzureHeaders = HttpAzureSharedKeyHelper.getCanonicalizedAzureHeaders(httpHeaders);
        String canonicalizedResource = HttpAzureSharedKeyHelper.getCanonicalizedResourceName(request.getResourceRef());
        StringBuilder rest = new StringBuilder();
        rest.append(methodName).append('\n').append(contentMd5).append('\n').append(contentType).append('\n').append(date).append('\n').append(canonicalizedAzureHeaders).append('/').append(challenge.getIdentifier()).append(canonicalizedResource);
        cw.append((CharSequence)challenge.getIdentifier()).append(':').append((CharSequence)Base64.encode((byte[])DigestUtils.toHMacSha256(rest.toString(), Base64.decode((char[])challenge.getSecret())), (boolean)true));
    }
}

