/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.crypto;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class DigestUtils {
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    public static char[] digest(char[] target, String algorithm) {
        return DigestUtils.digest(new String(target), algorithm).toCharArray();
    }

    public static String digest(String target, String algorithm) {
        if ("MD5".equals(algorithm)) {
            return DigestUtils.toMd5(target);
        }
        if ("SHA-1".equals(algorithm)) {
            return DigestUtils.toSha1(target);
        }
        throw new IllegalArgumentException("Unsupported algorithm.");
    }

    public static byte[] toHMacSha1(String source, byte[] secretKey) {
        byte[] result = null;
        try {
            SecretKeySpec signingKey = new SecretKeySpec(secretKey, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            result = mac.doFinal(source.getBytes());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("Could not find the SHA-1 algorithm. HMac conversion failed.", nsae);
        }
        catch (InvalidKeyException ike) {
            throw new RuntimeException("Invalid key exception detected. HMac conversion failed.", ike);
        }
        return result;
    }

    public static byte[] toHMacSha1(String source, String secretKey) {
        return DigestUtils.toHMacSha1(source, secretKey.getBytes());
    }

    public static byte[] toHMacSha256(String source, byte[] secretKey) {
        byte[] result = null;
        try {
            SecretKeySpec signingKey = new SecretKeySpec(secretKey, "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(signingKey);
            result = mac.doFinal(source.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("Could not find the SHA256 algorithm. HMac conversion failed.", nsae);
        }
        catch (InvalidKeyException ike) {
            throw new RuntimeException("Invalid key exception detected. HMac conversion failed.", ike);
        }
        catch (IllegalStateException ise) {
            throw new RuntimeException("IIllegal state exception detected. HMac conversion failed.", ise);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Unsuported encoding UTF-8. HMac conversion failed.", uee);
        }
        return result;
    }

    public static byte[] toHMacSha256(String source, String secretKey) {
        return DigestUtils.toHMacSha256(source, secretKey.getBytes());
    }

    public static String toHttpDigest(String identifier, char[] secret, String realm) {
        if (secret != null) {
            return DigestUtils.toMd5(identifier + ":" + realm + ":" + new String(secret));
        }
        return null;
    }

    public static String toMd5(String target) {
        try {
            return DigestUtils.toMd5(target, "US-ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("US-ASCII is an unsupported encoding, unable to compute MD5");
        }
    }

    public static String toMd5(String target, String charsetName) throws UnsupportedEncodingException {
        try {
            byte[] md5 = MessageDigest.getInstance("MD5").digest(target.getBytes(charsetName));
            char[] md5Chars = new char[32];
            int i = 0;
            for (byte b : md5) {
                md5Chars[i++] = HEXDIGITS[b >> 4 & 0xF];
                md5Chars[i++] = HEXDIGITS[b & 0xF];
            }
            return new String(md5Chars);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("No MD5 algorithm, unable to compute MD5");
        }
    }

    public static String toSha1(String target) {
        try {
            return DigestUtils.toSha1(target, "US-ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("US-ASCII is an unsupported encoding, unable to compute SHA1");
        }
    }

    public static String toSha1(String target, String charsetName) throws UnsupportedEncodingException {
        try {
            return Base64.getEncoder().encodeToString(MessageDigest.getInstance("SHA1").digest(target.getBytes(charsetName)));
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("No SHA1 algorithm, unable to compute SHA1");
        }
    }

    private DigestUtils() {
    }
}

