/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.crypto.internal;

import java.util.Base64;
import java.util.Date;
import org.restlet.Request;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.Header;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.engine.header.ChallengeWriter;
import org.restlet.engine.io.IoUtils;
import org.restlet.engine.security.AuthenticatorHelper;
import org.restlet.engine.util.DateUtils;
import org.restlet.ext.crypto.DigestUtils;
import org.restlet.util.Series;

public class HttpAzureSharedKeyLiteHelper
extends AuthenticatorHelper {
    private static String getCanonicalizedResourceName(Reference resourceRef) {
        Form form = resourceRef.getQueryAsForm();
        Parameter param = (Parameter)form.getFirst("comp", true);
        if (param != null) {
            StringBuilder sb = new StringBuilder(resourceRef.getPath());
            return sb.append("?").append("comp=").append(param.getValue()).toString();
        }
        return resourceRef.getPath();
    }

    public HttpAzureSharedKeyLiteHelper() {
        super(ChallengeScheme.HTTP_AZURE_SHAREDKEY_LITE, true, false);
    }

    public void formatResponse(ChallengeWriter cw, ChallengeResponse challenge, Request request, Series<Header> httpHeaders) {
        String date = "";
        if (httpHeaders.getFirstValue("x-ms-date", true) == null) {
            date = httpHeaders.getFirstValue("Date", true);
            if (date == null) {
                date = DateUtils.format((Date)new Date(), (String)((String)DateUtils.FORMAT_RFC_1123.get(0)));
                httpHeaders.add("Date", date);
            }
        } else {
            date = httpHeaders.getFirstValue("x-ms-date", true);
        }
        String canonicalizedResource = HttpAzureSharedKeyLiteHelper.getCanonicalizedResourceName(request.getResourceRef());
        StringBuilder rest = new StringBuilder();
        rest.append(date).append('\n').append('/').append(challenge.getIdentifier()).append(canonicalizedResource);
        cw.append((CharSequence)challenge.getIdentifier()).append(':').append((CharSequence)Base64.getEncoder().encodeToString(DigestUtils.toHMacSha256(rest.toString(), Base64.getDecoder().decode(IoUtils.toByteArray((char[])challenge.getSecret())))));
    }
}

