/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jetty.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.HttpConnection;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.Parameter;
import org.restlet.data.Status;
import org.restlet.engine.http.ServerCall;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyCall
extends ServerCall {
    private final HttpConnection connection;
    private volatile boolean requestHeadersAdded;

    public JettyCall(Server server, HttpConnection connection) {
        super(server);
        this.connection = connection;
        this.requestHeadersAdded = false;
    }

    public boolean abort() {
        try {
            this.getConnection().getEndPoint().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public void complete() {
        try {
            this.connection.flushResponse();
        }
        catch (IOException ex) {
            this.getLogger().log(Level.FINE, "Unable to flush the response", ex);
        }
        try {
            this.connection.completeResponse();
        }
        catch (IOException ex) {
            this.getLogger().log(Level.FINE, "Unable to complete the response", ex);
        }
    }

    public String getClientAddress() {
        return this.getConnection().getRequest().getRemoteAddr();
    }

    public int getClientPort() {
        return this.getConnection().getRequest().getRemotePort();
    }

    public HttpConnection getConnection() {
        return this.connection;
    }

    public String getMethod() {
        return this.getConnection().getRequest().getMethod();
    }

    public ReadableByteChannel getRequestEntityChannel(long size) {
        return null;
    }

    public InputStream getRequestEntityStream(long size) {
        try {
            return this.getConnection().getRequest().getInputStream();
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "Unable to get request entity stream", e);
            return null;
        }
    }

    public ReadableByteChannel getRequestHeadChannel() {
        return null;
    }

    public Series<Parameter> getRequestHeaders() {
        Series result = super.getRequestHeaders();
        if (!this.requestHeadersAdded) {
            Enumeration names = this.getConnection().getRequestFields().getFieldNames();
            while (names.hasMoreElements()) {
                String headerName = (String)names.nextElement();
                Enumeration values = this.getConnection().getRequestFields().getValues(headerName);
                while (values.hasMoreElements()) {
                    String headerValue = (String)values.nextElement();
                    result.add((Object)new Parameter(headerName, headerValue));
                }
            }
            this.requestHeadersAdded = true;
        }
        return result;
    }

    public InputStream getRequestHeadStream() {
        return null;
    }

    public String getRequestUri() {
        return this.getConnection().getRequest().getUri().toString();
    }

    public WritableByteChannel getResponseEntityChannel() {
        return null;
    }

    public OutputStream getResponseEntityStream() {
        try {
            return this.getConnection().getResponse().getOutputStream();
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "Unable to get response entity stream", e);
            return null;
        }
    }

    public String getServerAddress() {
        return this.getConnection().getRequest().getLocalAddr();
    }

    public String getSslCipherSuite() {
        return (String)this.getConnection().getRequest().getAttribute("javax.servlet.request.cipher_suite");
    }

    public List<Certificate> getSslClientCertificates() {
        Certificate[] certificateArray = (Certificate[])this.getConnection().getRequest().getAttribute("javax.servlet.request.X509Certificate");
        if (certificateArray != null) {
            return Arrays.asList(certificateArray);
        }
        return null;
    }

    public Integer getSslKeySize() {
        Integer keySize = (Integer)this.getConnection().getRequest().getAttribute("javax.servlet.request.key_size");
        if (keySize == null) {
            keySize = super.getSslKeySize();
        }
        return keySize;
    }

    public String getSslSessionId() {
        Object sessionId = this.getConnection().getRequest().getAttribute("javax.servlet.request.ssl_session_id");
        if (sessionId instanceof String) {
            return (String)sessionId;
        }
        return null;
    }

    public boolean isConfidential() {
        return this.getConnection().getRequest().isSecure();
    }

    public boolean isConnectionBroken(Exception exception) {
        return exception instanceof EofException || super.isConnectionBroken(exception);
    }

    public void sendResponse(Response response) throws IOException {
        for (Parameter header : this.getResponseHeaders()) {
            this.getConnection().getResponse().addHeader(header.getName(), header.getValue());
        }
        if (Status.isError((int)this.getStatusCode()) && response.getEntity() == null) {
            try {
                this.getConnection().getResponse().sendError(this.getStatusCode(), this.getReasonPhrase());
            }
            catch (IOException ioe) {
                this.getLogger().log(Level.WARNING, "Unable to set the response error status", ioe);
            }
        } else {
            this.getConnection().getResponse().setStatus(this.getStatusCode());
            super.sendResponse(response);
        }
    }
}

