/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jetty;

import java.io.File;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.engine.RestletHelper;
import org.restlet.engine.security.SslContextFactory;
import org.restlet.engine.security.SslUtils;
import org.restlet.ext.jetty.JettyServerHelper;

public class HttpsServerHelper
extends JettyServerHelper {
    public HttpsServerHelper(Server server) {
        super(server);
        this.getProtocols().add(Protocol.HTTPS);
    }

    protected AbstractConnector createConnector() {
        Object result = null;
        final SslContextFactory sslContextFactory = SslUtils.getSslContextFactory((RestletHelper)this);
        String[] excludedCipherSuites = SslUtils.getDisabledCipherSuites((RestletHelper)this);
        switch (this.getType()) {
            case 1: {
                SslSelectChannelConnector nioResult = new SslSelectChannelConnector(){

                    protected SSLContext createSSLContext() throws Exception {
                        return sslContextFactory.createSslContext();
                    }
                };
                if (this.isNeedClientAuthentication()) {
                    nioResult.setNeedClientAuth(true);
                } else if (this.isWantClientAuthentication()) {
                    nioResult.setWantClientAuth(true);
                }
                if (excludedCipherSuites != null) {
                    nioResult.setExcludeCipherSuites(excludedCipherSuites);
                }
                result = nioResult;
                break;
            }
            case 2: {
                SslSocketConnector bioResult = new SslSocketConnector(){

                    protected SSLServerSocketFactory createFactory() throws Exception {
                        SSLContext sslContext = sslContextFactory.createSslContext();
                        return sslContext.getServerSocketFactory();
                    }
                };
                if (this.isNeedClientAuthentication()) {
                    bioResult.setNeedClientAuth(true);
                } else if (this.isWantClientAuthentication()) {
                    bioResult.setWantClientAuth(true);
                }
                if (excludedCipherSuites != null) {
                    bioResult.setExcludeCipherSuites(excludedCipherSuites);
                }
                result = bioResult;
            }
        }
        return result;
    }

    @Deprecated
    public String getCertAlgorithm() {
        return this.getHelpedParameters().getFirstValue("certAlgorithm", "SunX509");
    }

    @Deprecated
    public String getKeyPassword() {
        return this.getHelpedParameters().getFirstValue("keyPassword", this.getKeystorePassword());
    }

    @Deprecated
    public String getKeystorePassword() {
        return this.getHelpedParameters().getFirstValue("keystorePassword", "");
    }

    @Deprecated
    public String getKeystorePath() {
        return this.getHelpedParameters().getFirstValue("keystorePath", System.getProperty("user.home") + File.separator + ".keystore");
    }

    @Deprecated
    public String getKeystoreType() {
        return this.getHelpedParameters().getFirstValue("keystoreType", "JKS");
    }

    @Deprecated
    public String getSecureRandomAlgorithm() {
        return this.getHelpedParameters().getFirstValue("secureRandomAlgorithm", null);
    }

    @Deprecated
    public String getSecurityProvider() {
        return this.getHelpedParameters().getFirstValue("securityProvider", null);
    }

    @Deprecated
    public String getSslProtocol() {
        return this.getHelpedParameters().getFirstValue("sslProtocol", "TLS");
    }

    public int getType() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("type", "2"));
    }

    public boolean isNeedClientAuthentication() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("needClientAuthentication", "false"));
    }

    public boolean isWantClientAuthentication() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("wantClientAuthentication", "false"));
    }
}

