/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jetty;

import java.util.logging.Level;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.engine.RestletHelper;
import org.restlet.engine.ssl.SslUtils;
import org.restlet.ext.jetty.JettyServerHelper;
import org.restlet.ext.jetty.internal.RestletSslContextFactory;

public class HttpsServerHelper
extends JettyServerHelper {
    public HttpsServerHelper(Server server) {
        super(server);
        this.getProtocols().add(Protocol.HTTPS);
    }

    @Override
    protected ConnectionFactory[] createConnectionFactories(HttpConfiguration configuration) {
        ConnectionFactory[] result = null;
        try {
            RestletSslContextFactory sslContextFactory = new RestletSslContextFactory(SslUtils.getSslContextFactory((RestletHelper)this));
            result = AbstractConnectionFactory.getFactories((SslContextFactory)sslContextFactory, (ConnectionFactory[])super.createConnectionFactories(configuration));
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Unable to create the Jetty SSL context factory", e);
            result = null;
        }
        return result;
    }
}

